package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAscpLogisticsIdentcodeUploadResponse;

/**
 * TOP API: alibaba.ascp.logistics.identcode.upload request
 * 
 * @author top auto create
 * @since 1.0, 2024.09.18
 */
public class AlibabaAscpLogisticsIdentcodeUploadRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsIdentcodeUploadResponse> {
	
	

	/** 
	* sn码列表，多个用逗号分隔
	 */
	private String codeList;

	/** 
	* 订单id
	 */
	private Long orderId;

	/** 
	* 1代表交易订单；2代表渠道订单，默认不传代表交易订单
	 */
	private Long orderType;

	public void setCodeList(String codeList) {
		this.codeList = codeList;
	}

	public String getCodeList() {
		return this.codeList;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setOrderType(Long orderType) {
		this.orderType = orderType;
	}

	public Long getOrderType() {
		return this.orderType;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.identcode.upload";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code_list", this.codeList);
		txtParams.put("order_id", this.orderId);
		txtParams.put("order_type", this.orderType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsIdentcodeUploadResponse> getResponseClass() {
		return AlibabaAscpLogisticsIdentcodeUploadResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(codeList, "codeList");
		RequestCheckUtils.checkNotEmpty(orderId, "orderId");
	}
	

}