package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAscpLogisticsSellerOrdersGetResponse;

/**
 * TOP API: alibaba.ascp.logistics.seller.orders.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.19
 */
public class AlibabaAscpLogisticsSellerOrdersGetRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsSellerOrdersGetResponse> {
	
	

	/** 
	* 分页索引
	 */
	private Long pageIndex;

	/** 
	* 分页大小
	 */
	private Long pageSize;

	/** 
	* 收货码
	 */
	private String receiveCode;

	/** 
	* 淘系交易id
	 */
	private String tid;

	/** 
	* 核销日期
	 */
	private String writeOffDate;

	/** 
	* 1代表未核销，2代表已核销
	 */
	private String writeOffStatus;

	public void setPageIndex(Long pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Long getPageIndex() {
		return this.pageIndex;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setReceiveCode(String receiveCode) {
		this.receiveCode = receiveCode;
	}

	public String getReceiveCode() {
		return this.receiveCode;
	}

	public void setTid(String tid) {
		this.tid = tid;
	}

	public String getTid() {
		return this.tid;
	}

	public void setWriteOffDate(String writeOffDate) {
		this.writeOffDate = writeOffDate;
	}

	public String getWriteOffDate() {
		return this.writeOffDate;
	}

	public void setWriteOffStatus(String writeOffStatus) {
		this.writeOffStatus = writeOffStatus;
	}

	public String getWriteOffStatus() {
		return this.writeOffStatus;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.seller.orders.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("page_index", this.pageIndex);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("receive_code", this.receiveCode);
		txtParams.put("tid", this.tid);
		txtParams.put("write_off_date", this.writeOffDate);
		txtParams.put("write_off_status", this.writeOffStatus);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsSellerOrdersGetResponse> getResponseClass() {
		return AlibabaAscpLogisticsSellerOrdersGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(receiveCode, "receiveCode");
	}
	

}