package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsSellerWritelogisticsnodeResponse;

/**
 * TOP API: alibaba.ascp.logistics.seller.writelogisticsnode request
 * 
 * @author top auto create
 * @since 1.0, 2023.04.14
 */
public class AlibabaAscpLogisticsSellerWritelogisticsnodeRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsSellerWritelogisticsnodeResponse> {
	
	

	/** 
	* 物流发货单号
	 */
	private Long lpOrderId;

	/** 
	* 物流节点
	 */
	private String nodes;

	public void setLpOrderId(Long lpOrderId) {
		this.lpOrderId = lpOrderId;
	}

	public Long getLpOrderId() {
		return this.lpOrderId;
	}

	public void setNodes(String nodes) {
		this.nodes = nodes;
	}

	public void setNodes(List<LogisticsNodeTopDTO> nodes) {
		this.nodes = new JSONWriter(false,true).write(nodes);
	}

	public String getNodes() {
		return this.nodes;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.seller.writelogisticsnode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("lp_order_id", this.lpOrderId);
		txtParams.put("nodes", this.nodes);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsSellerWritelogisticsnodeResponse> getResponseClass() {
		return AlibabaAscpLogisticsSellerWritelogisticsnodeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(lpOrderId, "lpOrderId");
		RequestCheckUtils.checkObjectMaxListSize(nodes, 100, "nodes");
	}
	
	/**
 * 配送员信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DeliveryTopDTO extends TaobaoObject {

	private static final long serialVersionUID = 5846451798466779426L;

	/**
		 * 配送员姓名
		 */
		@ApiField("name")
		private String name;
		/**
		 * 配送员电话，支持手机、座机、400电话
		 */
		@ApiField("phone")
		private String phone;
	

	public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getPhone() {
			return this.phone;
		}
		public void setPhone(String phone) {
			this.phone = phone;
		}

}

	/**
 * 货物所在的当前位置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LocationTopDTO extends TaobaoObject {

	private static final long serialVersionUID = 3543342175674147675L;

	/**
		 * 地级市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 区县
		 */
		@ApiField("district")
		private String district;
		/**
		 * 纬度，高德地图
		 */
		@ApiField("lat")
		private String lat;
		/**
		 * 经度，高德地图
		 */
		@ApiField("lng")
		private String lng;
		/**
		 * 省直辖市
		 */
		@ApiField("province")
		private String province;
		/**
		 * 乡镇街道
		 */
		@ApiField("town")
		private String town;
	

	public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getLat() {
			return this.lat;
		}
		public void setLat(String lat) {
			this.lat = lat;
		}
		public String getLng() {
			return this.lng;
		}
		public void setLng(String lng) {
			this.lng = lng;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}

}

	/**
 * 物流节点
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LogisticsNodeTopDTO extends TaobaoObject {

	private static final long serialVersionUID = 4243132481835333524L;

	/**
		 * ACCEPT(已揽收),TRANSPORT(运输中),DELIVERING(派送中),SIGN(已签收),CANCEL(已取消),FAILED(物流异常)
		 */
		@ApiField("action")
		private String action;
		/**
		 * 配送员信息
		 */
		@ApiField("delivery")
		private DeliveryTopDTO delivery;
		/**
		 * 货物所在的当前位置
		 */
		@ApiField("location")
		private LocationTopDTO location;
		/**
		 * 操作时间戳，精确到毫秒（ms）
		 */
		@ApiField("operate_time")
		private Long operateTime;
	

	public String getAction() {
			return this.action;
		}
		public void setAction(String action) {
			this.action = action;
		}
		public DeliveryTopDTO getDelivery() {
			return this.delivery;
		}
		public void setDelivery(DeliveryTopDTO delivery) {
			this.delivery = delivery;
		}
		public LocationTopDTO getLocation() {
			return this.location;
		}
		public void setLocation(LocationTopDTO location) {
			this.location = location;
		}
		public Long getOperateTime() {
			return this.operateTime;
		}
		public void setOperateTime(Long operateTime) {
			this.operateTime = operateTime;
		}

}


}