package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAscpLogisticsSellerWriteoffResponse;

/**
 * TOP API: alibaba.ascp.logistics.seller.writeoff request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.19
 */
public class AlibabaAscpLogisticsSellerWriteoffRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsSellerWriteoffResponse> {
	
	

	/** 
	* 所要核销的核销物流单ID，在alibaba.ascp.logistics.seller.orders.get中获取。
	 */
	private Long lpOrderId;

	/** 
	* 核销码
	 */
	private String receiveCode;

	public void setLpOrderId(Long lpOrderId) {
		this.lpOrderId = lpOrderId;
	}

	public Long getLpOrderId() {
		return this.lpOrderId;
	}

	public void setReceiveCode(String receiveCode) {
		this.receiveCode = receiveCode;
	}

	public String getReceiveCode() {
		return this.receiveCode;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.seller.writeoff";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("lp_order_id", this.lpOrderId);
		txtParams.put("receive_code", this.receiveCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsSellerWriteoffResponse> getResponseClass() {
		return AlibabaAscpLogisticsSellerWriteoffResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(lpOrderId, "lpOrderId");
		RequestCheckUtils.checkNotEmpty(receiveCode, "receiveCode");
	}
	

}