package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaGpuSchemaCatsearchResponse;

/**
 * TOP API: alibaba.gpu.schema.catsearch request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class AlibabaGpuSchemaCatsearchRequest extends BaseTaobaoRequest<AlibabaGpuSchemaCatsearchResponse> {
	
	

	/** 
	* 当前页
	 */
	private Long currentPage;

	/** 
	* 叶子类目ID
	 */
	private Long leafCatId;

	/** 
	* 每页大小
	 */
	private Long pageSize;

	/** 
	* 渠道Id，如0代表天猫，8代表淘宝
	 */
	private Long providerId;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setLeafCatId(Long leafCatId) {
		this.leafCatId = leafCatId;
	}

	public Long getLeafCatId() {
		return this.leafCatId;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setProviderId(Long providerId) {
		this.providerId = providerId;
	}

	public Long getProviderId() {
		return this.providerId;
	}

	public String getApiMethodName() {
		return "alibaba.gpu.schema.catsearch";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("current_page", this.currentPage);
		txtParams.put("leaf_cat_id", this.leafCatId);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("provider_id", this.providerId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaGpuSchemaCatsearchResponse> getResponseClass() {
		return AlibabaGpuSchemaCatsearchResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(currentPage, "currentPage");
		RequestCheckUtils.checkNotEmpty(leafCatId, "leafCatId");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(providerId, "providerId");
	}
	

}