package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaGpuSchemaUpdateResponse;

/**
 * TOP API: alibaba.gpu.schema.update request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class AlibabaGpuSchemaUpdateRequest extends BaseTaobaoRequest<AlibabaGpuSchemaUpdateResponse> {
	
	

	/** 
	* 产品ID
	 */
	private Long productId;

	/** 
	* 当前用户所在渠道如0代表天猫，8代表淘宝
	 */
	private Long providerId;

	/** 
	* 更新产品提交的schema数据
	 */
	private String schemaXmlFields;

	public void setProductId(Long productId) {
		this.productId = productId;
	}

	public Long getProductId() {
		return this.productId;
	}

	public void setProviderId(Long providerId) {
		this.providerId = providerId;
	}

	public Long getProviderId() {
		return this.providerId;
	}

	public void setSchemaXmlFields(String schemaXmlFields) {
		this.schemaXmlFields = schemaXmlFields;
	}

	public String getSchemaXmlFields() {
		return this.schemaXmlFields;
	}

	public String getApiMethodName() {
		return "alibaba.gpu.schema.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("product_id", this.productId);
		txtParams.put("provider_id", this.providerId);
		txtParams.put("schema_xml_fields", this.schemaXmlFields);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaGpuSchemaUpdateResponse> getResponseClass() {
		return AlibabaGpuSchemaUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(productId, "productId");
		RequestCheckUtils.checkNotEmpty(providerId, "providerId");
		RequestCheckUtils.checkNotEmpty(schemaXmlFields, "schemaXmlFields");
	}
	

}