package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingBuygiftItemAddAsyncResponse;

/**
 * TOP API: alibaba.hm.marketing.buygift.item.add.async request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.03
 */
public class AlibabaHmMarketingBuygiftItemAddAsyncRequest extends BaseTaobaoRequest<AlibabaHmMarketingBuygiftItemAddAsyncResponse> {
	
	

	/** 
	* sku信息
	 */
	private String param0;

	/** 
	* 系统自动生成
	 */
	private String param1;

	/** 
	* alibaba.wdk.marketing.version.generate接口生成
	 */
	private Long version;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(List<ItemBuyGiftSku> param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public void setVersion(Long version) {
		this.version = version;
	}

	public Long getVersion() {
		return this.version;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.buygift.item.add.async";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		txtParams.put("version", this.version);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingBuygiftItemAddAsyncResponse> getResponseClass() {
		return AlibabaHmMarketingBuygiftItemAddAsyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(param0, 20, "param0");
		RequestCheckUtils.checkNotEmpty(version, "version");
	}
	
	/**
 * 限购信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 5625824492714288512L;

	/**
		 * 每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 用户每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 用户总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * sku信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemBuyGiftSku extends TaobaoObject {

	private static final long serialVersionUID = 2288593349596242365L;

	/**
		 * 买赠门槛数量
		 */
		@ApiField("buy_num")
		private Long buyNum;
		/**
		 * 赠品的skuCode
		 */
		@ApiField("gift_sku_code")
		private String giftSkuCode;
		/**
		 * 限购信息
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getBuyNum() {
			return this.buyNum;
		}
		public void setBuyNum(Long buyNum) {
			this.buyNum = buyNum;
		}
		public String getGiftSkuCode() {
			return this.giftSkuCode;
		}
		public void setGiftSkuCode(String giftSkuCode) {
			this.giftSkuCode = giftSkuCode;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 7599119689348125492L;

	/**
		 * 活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 外部活动编码
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}