package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingCouponSendmaResponse;

/**
 * TOP API: alibaba.hm.marketing.coupon.sendma request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.04
 */
public class AlibabaHmMarketingCouponSendmaRequest extends BaseTaobaoRequest<AlibabaHmMarketingCouponSendmaResponse> {
	
	

	/** 
	* 发放匿名码入参
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(CommonActivityParam param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.coupon.sendma";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingCouponSendmaResponse> getResponseClass() {
		return AlibabaHmMarketingCouponSendmaResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 发放匿名码入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 6229873167892798974L;

	/**
		 * 五道口优惠券活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家优惠券活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}