package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingDiscountItemAddAsyncResponse;

/**
 * TOP API: alibaba.hm.marketing.discount.item.add.async request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.04
 */
public class AlibabaHmMarketingDiscountItemAddAsyncRequest extends BaseTaobaoRequest<AlibabaHmMarketingDiscountItemAddAsyncResponse> {
	
	

	/** 
	* sku信息
	 */
	private String param0;

	/** 
	* 系统自动生成
	 */
	private String param1;

	/** 
	* alibaba.wdk.marketing.version.generate接口生成
	 */
	private Long version;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(List<ItemDiscountSku> param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public void setVersion(Long version) {
		this.version = version;
	}

	public Long getVersion() {
		return this.version;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.discount.item.add.async";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		txtParams.put("version", this.version);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingDiscountItemAddAsyncResponse> getResponseClass() {
		return AlibabaHmMarketingDiscountItemAddAsyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(param0, 20, "param0");
		RequestCheckUtils.checkNotEmpty(version, "version");
	}
	
	/**
 * 限购信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 5321682941829568275L;

	/**
		 * 每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 用户每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 用户总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * sku信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountSku extends TaobaoObject {

	private static final long serialVersionUID = 5281529969311577235L;

	/**
		 * 门槛数量，金额值单位为分
		 */
		@ApiField("condition_num")
		private Long conditionNum;
		/**
		 * 门槛类型，2：累计消费金额，3：累计购买次数
		 */
		@ApiField("condition_type")
		private Long conditionType;
		/**
		 * 限购信息
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * <优惠明细,分为单位>优惠类型为[减价],则代表直降金额[如700,表示商品直降7元];优惠券类型为[一口价],则代表一口价[如700,表示商品一口价为7元];优惠券类型为[打折],则代表折扣[如700,表示打7折]
		 */
		@ApiField("value")
		private Long value;
	

	public Long getConditionNum() {
			return this.conditionNum;
		}
		public void setConditionNum(Long conditionNum) {
			this.conditionNum = conditionNum;
		}
		public Long getConditionType() {
			return this.conditionType;
		}
		public void setConditionType(Long conditionType) {
			this.conditionType = conditionType;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public Long getValue() {
			return this.value;
		}
		public void setValue(Long value) {
			this.value = value;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 4514947244664432242L;

	/**
		 * 活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 外部活动编码
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}