package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaHmMarketingExpirePromotionQueryResponse;

/**
 * TOP API: alibaba.hm.marketing.expire.promotion.query request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.04
 */
public class AlibabaHmMarketingExpirePromotionQueryRequest extends BaseTaobaoRequest<AlibabaHmMarketingExpirePromotionQueryResponse> {
	
	

	/** 
	* 店铺id
	 */
	private String shopId;

	/** 
	* 商品skucode
	 */
	private String skuCode;

	public void setShopId(String shopId) {
		this.shopId = shopId;
	}

	public String getShopId() {
		return this.shopId;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuCode() {
		return this.skuCode;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.expire.promotion.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("shop_id", this.shopId);
		txtParams.put("sku_code", this.skuCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingExpirePromotionQueryResponse> getResponseClass() {
		return AlibabaHmMarketingExpirePromotionQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(shopId, "shopId");
		RequestCheckUtils.checkNotEmpty(skuCode, "skuCode");
	}
	

}