package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItembuygiftAdditemResponse;

/**
 * TOP API: alibaba.hm.marketing.itembuygift.additem request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.03
 */
public class AlibabaHmMarketingItembuygiftAdditemRequest extends BaseTaobaoRequest<AlibabaHmMarketingItembuygiftAdditemResponse> {
	
	

	/** 
	* 商品对象
	 */
	private String param0;

	/** 
	* 活动基本信息
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemBuyGiftSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itembuygift.additem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItembuygiftAdditemResponse> getResponseClass() {
		return AlibabaHmMarketingItembuygiftAdditemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 6841433928755775388L;

	/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 商品对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemBuyGiftSku extends TaobaoObject {

	private static final long serialVersionUID = 5581192636364735623L;

	/**
		 * 买N赠1的N
		 */
		@ApiField("buy_num")
		private Long buyNum;
		/**
		 * 赠品的skuCode，如果和主商品的skuCode相同，则为买A赠A；如果不同，则为买A赠B
		 */
		@ApiField("gift_sku_code")
		private String giftSkuCode;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 主商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getBuyNum() {
			return this.buyNum;
		}
		public void setBuyNum(Long buyNum) {
			this.buyNum = buyNum;
		}
		public String getGiftSkuCode() {
			return this.giftSkuCode;
		}
		public void setGiftSkuCode(String giftSkuCode) {
			this.giftSkuCode = giftSkuCode;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 活动基本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 7799195631963154637L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}