package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItemdiscountAdditemResponse;

/**
 * TOP API: alibaba.hm.marketing.itemdiscount.additem request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.30
 */
public class AlibabaHmMarketingItemdiscountAdditemRequest extends BaseTaobaoRequest<AlibabaHmMarketingItemdiscountAdditemResponse> {
	
	

	/** 
	* 商品对象
	 */
	private String param0;

	/** 
	* 活动基本信息
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemDiscountSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itemdiscount.additem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItemdiscountAdditemResponse> getResponseClass() {
		return AlibabaHmMarketingItemdiscountAdditemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 6323815961841686121L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 活动每日总限购（非标小数）
		 */
		@ApiField("daily_limit_cnt_double")
		private String dailyLimitCntDouble;
		/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 活动期间总限购（非标小数）
		 */
		@ApiField("total_limit_cnt_double")
		private String totalLimitCntDouble;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人每日限购（非标小数）
		 */
		@ApiField("user_daily_limit_cnt_double")
		private String userDailyLimitCntDouble;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
		/**
		 * 每人活动期间总限购（非标小数）
		 */
		@ApiField("user_limit_cnt_double")
		private String userLimitCntDouble;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public String getDailyLimitCntDouble() {
			return this.dailyLimitCntDouble;
		}
		public void setDailyLimitCntDouble(String dailyLimitCntDouble) {
			this.dailyLimitCntDouble = dailyLimitCntDouble;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public String getTotalLimitCntDouble() {
			return this.totalLimitCntDouble;
		}
		public void setTotalLimitCntDouble(String totalLimitCntDouble) {
			this.totalLimitCntDouble = totalLimitCntDouble;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public String getUserDailyLimitCntDouble() {
			return this.userDailyLimitCntDouble;
		}
		public void setUserDailyLimitCntDouble(String userDailyLimitCntDouble) {
			this.userDailyLimitCntDouble = userDailyLimitCntDouble;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}
		public String getUserLimitCntDouble() {
			return this.userLimitCntDouble;
		}
		public void setUserLimitCntDouble(String userLimitCntDouble) {
			this.userLimitCntDouble = userLimitCntDouble;
		}

}

	/**
 * 商品对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountSku extends TaobaoObject {

	private static final long serialVersionUID = 3254476784778816394L;

	/**
		 * 门槛数量，金额值单位为分
		 */
		@ApiField("condition_num")
		private Long conditionNum;
		/**
		 * 门槛类型，2：累计消费金额，3：累计购买次数
		 */
		@ApiField("condition_type")
		private Long conditionType;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 商品名称
		 */
		@ApiField("sku_name")
		private String skuName;
		/**
		 * <优惠明细,分为单位>优惠类型为[减价],则代表直降金额[如700,表示商品直降7元];优惠券类型为[一口价],则代表一口价[如700,表示商品一口价为7元];优惠券类型为[打折],则代表折扣[如700,表示打7折]
		 */
		@ApiField("value")
		private Long value;
	

	public Long getConditionNum() {
			return this.conditionNum;
		}
		public void setConditionNum(Long conditionNum) {
			this.conditionNum = conditionNum;
		}
		public Long getConditionType() {
			return this.conditionType;
		}
		public void setConditionType(Long conditionType) {
			this.conditionType = conditionType;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getSkuName() {
			return this.skuName;
		}
		public void setSkuName(String skuName) {
			this.skuName = skuName;
		}
		public Long getValue() {
			return this.value;
		}
		public void setValue(Long value) {
			this.value = value;
		}

}

	/**
 * 自定义同步的渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 4431831668566763131L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 活动基本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 6377338316997445336L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步的渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}