package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItemdiscountCreateactivityResponse;

/**
 * TOP API: alibaba.hm.marketing.itemdiscount.createactivity request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.30
 */
public class AlibabaHmMarketingItemdiscountCreateactivityRequest extends BaseTaobaoRequest<AlibabaHmMarketingItemdiscountCreateactivityResponse> {
	
	

	/** 
	* 创建活动请求入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(ItemDiscountActivityRequest param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itemdiscount.createactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItemdiscountCreateactivityResponse> getResponseClass() {
		return AlibabaHmMarketingItemdiscountCreateactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 周期优惠信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PeriodConfig extends TaobaoObject {

	private static final long serialVersionUID = 7235529674995737115L;

	/**
		 * 每天的那些时间段生效
		 */
		@ApiListField("every_day_periods")
		@ApiField("string")
		private List<String> everyDayPeriods;
		/**
		 * 一周的哪几天生效
		 */
		@ApiListField("weekdays")
		@ApiField("number")
		private List<Long> weekdays;
	

	public List<String> getEveryDayPeriods() {
			return this.everyDayPeriods;
		}
		public void setEveryDayPeriods(List<String> everyDayPeriods) {
			this.everyDayPeriods = everyDayPeriods;
		}
		public List<Long> getWeekdays() {
			return this.weekdays;
		}
		public void setWeekdays(List<Long> weekdays) {
			this.weekdays = weekdays;
		}

}

	/**
 * 自定义同步的渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 5779828248773931631L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 创建活动请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountActivityRequest extends TaobaoObject {

	private static final long serialVersionUID = 6333511276668967816L;

	/**
		 * 渠道编码
		 */
		@ApiField("activity_channel")
		private String activityChannel;
		/**
		 * 活动名称,不超过10个英文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步的渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 是否参加后单压前单，默认不参加
		 */
		@ApiField("cover_before")
		private Boolean coverBefore;
		/**
		 * 活动详情描述,不超过30个英文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 商品特价优惠方式[itemDecreaseMoney:商品特价减钱;itemFixPrice:商品特价一口价;itemDiscount:商品特价打折]
		 */
		@ApiField("discount_type")
		private String discountType;
		/**
		 * 活动结束时间,时间戳
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 会员维度活动参与人群限制[-1:不限制;1:会员专享;2:非会员专享]
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 周期优惠信息
		 */
		@ApiField("period_config")
		private PeriodConfig periodConfig;
		/**
		 * 活动优先级，值越大表示优先级越高，必须大于0
		 */
		@ApiField("priority_value")
		private Long priorityValue;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 活动开始时间,时间戳
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public String getActivityChannel() {
			return this.activityChannel;
		}
		public void setActivityChannel(String activityChannel) {
			this.activityChannel = activityChannel;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public Boolean getCoverBefore() {
			return this.coverBefore;
		}
		public void setCoverBefore(Boolean coverBefore) {
			this.coverBefore = coverBefore;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(String discountType) {
			this.discountType = discountType;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public PeriodConfig getPeriodConfig() {
			return this.periodConfig;
		}
		public void setPeriodConfig(PeriodConfig periodConfig) {
			this.periodConfig = periodConfig;
		}
		public Long getPriorityValue() {
			return this.priorityValue;
		}
		public void setPriorityValue(Long priorityValue) {
			this.priorityValue = priorityValue;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}


}