package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItempoolAddcategoryResponse;

/**
 * TOP API: alibaba.hm.marketing.itempool.addcategory request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.30
 */
public class AlibabaHmMarketingItempoolAddcategoryRequest extends BaseTaobaoRequest<AlibabaHmMarketingItempoolAddcategoryResponse> {
	
	

	/** 
	* 活动对象
	 */
	private String commonActivityParam;

	/** 
	* 类目对象
	 */
	private String itemPoolActivityCategory;

	public void setCommonActivityParam(String commonActivityParam) {
		this.commonActivityParam = commonActivityParam;
	}

	public void setCommonActivityParam(CommonActivityParam commonActivityParam) {
		this.commonActivityParam = new JSONWriter(false,true).write(commonActivityParam);
	}

	public String getCommonActivityParam() {
		return this.commonActivityParam;
	}

	public void setItemPoolActivityCategory(String itemPoolActivityCategory) {
		this.itemPoolActivityCategory = itemPoolActivityCategory;
	}

	public void setItemPoolActivityCategory(ItemPoolActivityCategory itemPoolActivityCategory) {
		this.itemPoolActivityCategory = new JSONWriter(false,true).write(itemPoolActivityCategory);
	}

	public String getItemPoolActivityCategory() {
		return this.itemPoolActivityCategory;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itempool.addcategory";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("common_activity_param", this.commonActivityParam);
		txtParams.put("item_pool_activity_category", this.itemPoolActivityCategory);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItempoolAddcategoryResponse> getResponseClass() {
		return AlibabaHmMarketingItempoolAddcategoryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 类目对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolActivityCategory extends TaobaoObject {

	private static final long serialVersionUID = 6827197833651142788L;

	/**
		 * 类目分组
		 */
		@ApiField("category_id")
		private String categoryId;
		/**
		 * 分组id
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
	

	public String getCategoryId() {
			return this.categoryId;
		}
		public void setCategoryId(String categoryId) {
			this.categoryId = categoryId;
		}
		public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}

}

	/**
 * 活动对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 2113679484862555588L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}