package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItempoolAdditemResponse;

/**
 * TOP API: alibaba.hm.marketing.itempool.additem request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.30
 */
public class AlibabaHmMarketingItempoolAdditemRequest extends BaseTaobaoRequest<AlibabaHmMarketingItempoolAdditemResponse> {
	
	

	/** 
	* 商品对象
	 */
	private String param0;

	/** 
	* 活动基本信息
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemPoolSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itempool.additem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItempoolAdditemResponse> getResponseClass() {
		return AlibabaHmMarketingItempoolAdditemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 商品对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolSku extends TaobaoObject {

	private static final long serialVersionUID = 7553986596568255667L;

	/**
		 * 减钱【元】
		 */
		@ApiField("decrease_money")
		private Long decreaseMoney;
		/**
		 * 折扣率，300=3折
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 一口价金额【分】
		 */
		@ApiField("fix_price")
		private Long fixPrice;
		/**
		 * 是否为减钱
		 */
		@ApiField("is_decrease_money")
		private Boolean isDecreaseMoney;
		/**
		 * 是否为商品折扣
		 */
		@ApiField("is_discount_rate")
		private Boolean isDiscountRate;
		/**
		 * 是否为一口价
		 */
		@ApiField("is_fix_price")
		private Boolean isFixPrice;
		/**
		 * 逻辑分组ID
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
		/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getDecreaseMoney() {
			return this.decreaseMoney;
		}
		public void setDecreaseMoney(Long decreaseMoney) {
			this.decreaseMoney = decreaseMoney;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Long getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Long fixPrice) {
			this.fixPrice = fixPrice;
		}
		public Boolean getIsDecreaseMoney() {
			return this.isDecreaseMoney;
		}
		public void setIsDecreaseMoney(Boolean isDecreaseMoney) {
			this.isDecreaseMoney = isDecreaseMoney;
		}
		public Boolean getIsDiscountRate() {
			return this.isDiscountRate;
		}
		public void setIsDiscountRate(Boolean isDiscountRate) {
			this.isDiscountRate = isDiscountRate;
		}
		public Boolean getIsFixPrice() {
			return this.isFixPrice;
		}
		public void setIsFixPrice(Boolean isFixPrice) {
			this.isFixPrice = isFixPrice;
		}
		public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 自定义同步渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 6898773861354259121L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 活动基本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 5552251589378536163L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}