package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingItempoolStairQueryitemResponse;

/**
 * TOP API: alibaba.hm.marketing.itempool.stair.queryitem request
 * 
 * @author top auto create
 * @since 1.0, 2023.06.30
 */
public class AlibabaHmMarketingItempoolStairQueryitemRequest extends BaseTaobaoRequest<AlibabaHmMarketingItempoolStairQueryitemResponse> {
	
	

	/** 
	* 换购商品查询参数
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ActivitySkuQuery param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.itempool.stair.queryitem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingItempoolStairQueryitemResponse> getResponseClass() {
		return AlibabaHmMarketingItempoolStairQueryitemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 分页参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BasePageQuery extends TaobaoObject {

	private static final long serialVersionUID = 2349342914151324999L;

	/**
		 * 当前页数
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}

	/**
 * 换购商品查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivitySkuQuery extends TaobaoObject {

	private static final long serialVersionUID = 8337327158536319538L;

	/**
		 * 报名活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 分页参数
		 */
		@ApiField("page")
		private BasePageQuery page;
		/**
		 * 查询指定的skucode
		 */
		@ApiListField("sku_codes")
		@ApiField("string")
		private List<String> skuCodes;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public BasePageQuery getPage() {
			return this.page;
		}
		public void setPage(BasePageQuery page) {
			this.page = page;
		}
		public List<String> getSkuCodes() {
			return this.skuCodes;
		}
		public void setSkuCodes(List<String> skuCodes) {
			this.skuCodes = skuCodes;
		}

}


}