package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaHmMarketingVersionCommitResponse;

/**
 * TOP API: alibaba.hm.marketing.version.commit request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.03
 */
public class AlibabaHmMarketingVersionCommitRequest extends BaseTaobaoRequest<AlibabaHmMarketingVersionCommitResponse> {
	
	

	/** 
	* 版本号提交参数
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(SeasonVersionCommitParam param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.hm.marketing.version.commit";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaHmMarketingVersionCommitResponse> getResponseClass() {
		return AlibabaHmMarketingVersionCommitResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 版本号提交参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SeasonVersionCommitParam extends TaobaoObject {

	private static final long serialVersionUID = 3387194247496497935L;

	/**
		 * generate的版本号
		 */
		@ApiField("season_version")
		private Long seasonVersion;
	

	public Long getSeasonVersion() {
			return this.seasonVersion;
		}
		public void setSeasonVersion(Long seasonVersion) {
			this.seasonVersion = seasonVersion;
		}

}


}