package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponAbandonResponse;

/**
 * TOP API: alibaba.wdk.coupon.abandon request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkCouponAbandonRequest extends BaseTaobaoRequest<AlibabaWdkCouponAbandonResponse> {
	
	

	/** 
	* 废券参数
	 */
	private String paramWdkCouponAbandonParam;

	public void setParamWdkCouponAbandonParam(String paramWdkCouponAbandonParam) {
		this.paramWdkCouponAbandonParam = paramWdkCouponAbandonParam;
	}

	public void setParamWdkCouponAbandonParam(WdkCouponAbandonParam paramWdkCouponAbandonParam) {
		this.paramWdkCouponAbandonParam = new JSONWriter(false,true).write(paramWdkCouponAbandonParam);
	}

	public String getParamWdkCouponAbandonParam() {
		return this.paramWdkCouponAbandonParam;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.abandon";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_wdk_coupon_abandon_param", this.paramWdkCouponAbandonParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponAbandonResponse> getResponseClass() {
		return AlibabaWdkCouponAbandonResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 废券参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WdkCouponAbandonParam extends TaobaoObject {

	private static final long serialVersionUID = 6828231794387751511L;

	/**
		 * 券涞源 写死
		 */
		@ApiField("coupon_source")
		private String couponSource;
		/**
		 * 匿名码
		 */
		@ApiField("ma_code")
		private String maCode;
		/**
		 * 优惠券模版id
		 */
		@ApiField("template_id")
		private String templateId;
		/**
		 * 用户id 写死
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 卡券实例id
		 */
		@ApiField("voucher_id")
		private Long voucherId;
	

	public String getCouponSource() {
			return this.couponSource;
		}
		public void setCouponSource(String couponSource) {
			this.couponSource = couponSource;
		}
		public String getMaCode() {
			return this.maCode;
		}
		public void setMaCode(String maCode) {
			this.maCode = maCode;
		}
		public String getTemplateId() {
			return this.templateId;
		}
		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public Long getVoucherId() {
			return this.voucherId;
		}
		public void setVoucherId(Long voucherId) {
			this.voucherId = voucherId;
		}

}


}