package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponSkuAddResponse;

/**
 * TOP API: alibaba.wdk.coupon.sku.add request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkCouponSkuAddRequest extends BaseTaobaoRequest<AlibabaWdkCouponSkuAddResponse> {
	
	

	/** 
	* 请求
	 */
	private String paramCouponTemplateItemRequest;

	public void setParamCouponTemplateItemRequest(String paramCouponTemplateItemRequest) {
		this.paramCouponTemplateItemRequest = paramCouponTemplateItemRequest;
	}

	public void setParamCouponTemplateItemRequest(CouponTemplateItemRequest paramCouponTemplateItemRequest) {
		this.paramCouponTemplateItemRequest = new JSONWriter(false,true).write(paramCouponTemplateItemRequest);
	}

	public String getParamCouponTemplateItemRequest() {
		return this.paramCouponTemplateItemRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.sku.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_coupon_template_item_request", this.paramCouponTemplateItemRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponSkuAddResponse> getResponseClass() {
		return AlibabaWdkCouponSkuAddResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 券圈品设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromActSku extends TaobaoObject {

	private static final long serialVersionUID = 3349853364529165941L;

	/**
		 * 商家逻辑分组序号
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
		/**
		 * 参与者id
		 */
		@ApiField("participate_id")
		private String participateId;
		/**
		 * 参与者名称
		 */
		@ApiField("participate_name")
		private String participateName;
		/**
		 * 参与者类型 SKU_CODE(1, "商品skuCode"), SHOP(2, "店铺"), CATEGORY(3, "品类")
		 */
		@ApiField("participate_type")
		private Long participateType;
	

	public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}
		public String getParticipateId() {
			return this.participateId;
		}
		public void setParticipateId(String participateId) {
			this.participateId = participateId;
		}
		public String getParticipateName() {
			return this.participateName;
		}
		public void setParticipateName(String participateName) {
			this.participateName = participateName;
		}
		public Long getParticipateType() {
			return this.participateType;
		}
		public void setParticipateType(Long participateType) {
			this.participateType = participateType;
		}

}

	/**
 * 用户信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfo extends TaobaoObject {

	private static final long serialVersionUID = 4667837797584168477L;

	/**
		 * 来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 用户名称
		 */
		@ApiField("user_name")
		private String userName;
	

	public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUserName() {
			return this.userName;
		}
		public void setUserName(String userName) {
			this.userName = userName;
		}

}

	/**
 * 请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateItemRequest extends TaobaoObject {

	private static final long serialVersionUID = 1183445671381697561L;

	/**
		 * 模板表主键id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 券圈品设置
		 */
		@ApiListField("prom_act_sku_list")
		@ApiField("prom_act_sku")
		private List<PromActSku> promActSkuList;
		/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
		/**
		 * 用户信息
		 */
		@ApiField("user_info")
		private UserInfo userInfo;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public List<PromActSku> getPromActSkuList() {
			return this.promActSkuList;
		}
		public void setPromActSkuList(List<PromActSku> promActSkuList) {
			this.promActSkuList = promActSkuList;
		}
		public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}
		public UserInfo getUserInfo() {
			return this.userInfo;
		}
		public void setUserInfo(UserInfo userInfo) {
			this.userInfo = userInfo;
		}

}


}