package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponSkuQueryResponse;

/**
 * TOP API: alibaba.wdk.coupon.sku.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkCouponSkuQueryRequest extends BaseTaobaoRequest<AlibabaWdkCouponSkuQueryResponse> {
	
	

	/** 
	* 请求
	 */
	private String paramCouponTemplateItemQueryRequest;

	public void setParamCouponTemplateItemQueryRequest(String paramCouponTemplateItemQueryRequest) {
		this.paramCouponTemplateItemQueryRequest = paramCouponTemplateItemQueryRequest;
	}

	public void setParamCouponTemplateItemQueryRequest(CouponTemplateItemQueryRequest paramCouponTemplateItemQueryRequest) {
		this.paramCouponTemplateItemQueryRequest = new JSONWriter(false,true).write(paramCouponTemplateItemQueryRequest);
	}

	public String getParamCouponTemplateItemQueryRequest() {
		return this.paramCouponTemplateItemQueryRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.sku.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_coupon_template_item_query_request", this.paramCouponTemplateItemQueryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponSkuQueryResponse> getResponseClass() {
		return AlibabaWdkCouponSkuQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 分页信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PageInfo extends TaobaoObject {

	private static final long serialVersionUID = 3173123897726234237L;

	/**
		 * 第几页
		 */
		@ApiField("page_num")
		private Long pageNum;
		/**
		 * 每页条数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 总共多少页
		 */
		@ApiField("pages")
		private Long pages;
		/**
		 * 总共多少条
		 */
		@ApiField("total")
		private Long total;
	

	public Long getPageNum() {
			return this.pageNum;
		}
		public void setPageNum(Long pageNum) {
			this.pageNum = pageNum;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getPages() {
			return this.pages;
		}
		public void setPages(Long pages) {
			this.pages = pages;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}

}

	/**
 * 用户信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfo extends TaobaoObject {

	private static final long serialVersionUID = 8258359496413723518L;

	/**
		 * 来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 用户名称
		 */
		@ApiField("user_name")
		private String userName;
	

	public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUserName() {
			return this.userName;
		}
		public void setUserName(String userName) {
			this.userName = userName;
		}

}

	/**
 * 请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateItemQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 4139965163739269338L;

	/**
		 * 模板表主键id
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 分组序号
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
		/**
		 * 分页信息
		 */
		@ApiField("page_info")
		private PageInfo pageInfo;
		/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
		/**
		 * 用户信息
		 */
		@ApiField("user_info")
		private UserInfo userInfo;
		/**
		 * 五道口分组id
		 */
		@ApiField("wdk_group_id")
		private Long wdkGroupId;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}
		public PageInfo getPageInfo() {
			return this.pageInfo;
		}
		public void setPageInfo(PageInfo pageInfo) {
			this.pageInfo = pageInfo;
		}
		public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}
		public UserInfo getUserInfo() {
			return this.userInfo;
		}
		public void setUserInfo(UserInfo userInfo) {
			this.userInfo = userInfo;
		}
		public Long getWdkGroupId() {
			return this.wdkGroupId;
		}
		public void setWdkGroupId(Long wdkGroupId) {
			this.wdkGroupId = wdkGroupId;
		}

}


}