package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponSpreadApplyResponse;

/**
 * TOP API: alibaba.wdk.coupon.spread.apply request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkCouponSpreadApplyRequest extends BaseTaobaoRequest<AlibabaWdkCouponSpreadApplyResponse> {
	
	

	/** 
	* 参数对象
	 */
	private String paramWdkCouponApplyParam;

	public void setParamWdkCouponApplyParam(String paramWdkCouponApplyParam) {
		this.paramWdkCouponApplyParam = paramWdkCouponApplyParam;
	}

	public void setParamWdkCouponApplyParam(WdkCouponApplyParam paramWdkCouponApplyParam) {
		this.paramWdkCouponApplyParam = new JSONWriter(false,true).write(paramWdkCouponApplyParam);
	}

	public String getParamWdkCouponApplyParam() {
		return this.paramWdkCouponApplyParam;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.spread.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_wdk_coupon_apply_param", this.paramWdkCouponApplyParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponSpreadApplyResponse> getResponseClass() {
		return AlibabaWdkCouponSpreadApplyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 参数对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WdkCouponApplyParam extends TaobaoObject {

	private static final long serialVersionUID = 2761564763682331329L;

	/**
		 * 申请渠道
		 */
		@ApiField("apply_channel")
		private String applyChannel;
		/**
		 * 券领取来源，非必填，用于区分不同的业务来源，默认传空为领取普通优惠券
		 */
		@ApiField("apply_source")
		private String applySource;
		/**
		 * 卡券来源  [ump:ump卡券; koubei:口碑券]
		 */
		@ApiField("coupon_source")
		private String couponSource;
		/**
		 * 拓展属性
		 */
		@ApiField("features")
		private String features;
		/**
		 * 幂等键
		 */
		@ApiField("idempotent_key")
		private String idempotentKey;
		/**
		 * 外部业务id
		 */
		@ApiField("out_biz_no")
		private String outBizNo;
		/**
		 * 优惠券模版id
		 */
		@ApiField("template_id")
		private String templateId;
		/**
		 * 领取淘系id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 优惠券模版uuid
		 */
		@ApiField("uuid")
		private String uuid;
	

	public String getApplyChannel() {
			return this.applyChannel;
		}
		public void setApplyChannel(String applyChannel) {
			this.applyChannel = applyChannel;
		}
		public String getApplySource() {
			return this.applySource;
		}
		public void setApplySource(String applySource) {
			this.applySource = applySource;
		}
		public String getCouponSource() {
			return this.couponSource;
		}
		public void setCouponSource(String couponSource) {
			this.couponSource = couponSource;
		}
		public String getFeatures() {
			return this.features;
		}
		public void setFeatures(String features) {
			this.features = features;
		}
		public void setFeaturesString(String features) {
			this.features = features;
		}
		
		public String getIdempotentKey() {
			return this.idempotentKey;
		}
		public void setIdempotentKey(String idempotentKey) {
			this.idempotentKey = idempotentKey;
		}
		public String getOutBizNo() {
			return this.outBizNo;
		}
		public void setOutBizNo(String outBizNo) {
			this.outBizNo = outBizNo;
		}
		public String getTemplateId() {
			return this.templateId;
		}
		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUuid() {
			return this.uuid;
		}
		public void setUuid(String uuid) {
			this.uuid = uuid;
		}

}


}