package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponTemplateCreateResponse;

/**
 * TOP API: alibaba.wdk.coupon.template.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.01
 */
public class AlibabaWdkCouponTemplateCreateRequest extends BaseTaobaoRequest<AlibabaWdkCouponTemplateCreateResponse> {
	
	

	/** 
	* 请求
	 */
	private String paramCouponTemplateOperateRequest;

	public void setParamCouponTemplateOperateRequest(String paramCouponTemplateOperateRequest) {
		this.paramCouponTemplateOperateRequest = paramCouponTemplateOperateRequest;
	}

	public void setParamCouponTemplateOperateRequest(CouponTemplateOperateRequest paramCouponTemplateOperateRequest) {
		this.paramCouponTemplateOperateRequest = new JSONWriter(false,true).write(paramCouponTemplateOperateRequest);
	}

	public String getParamCouponTemplateOperateRequest() {
		return this.paramCouponTemplateOperateRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.template.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_coupon_template_operate_request", this.paramCouponTemplateOperateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponTemplateCreateResponse> getResponseClass() {
		return AlibabaWdkCouponTemplateCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 领取限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateApplyLimitConfig extends TaobaoObject {

	private static final long serialVersionUID = 4716525453983348688L;

	/**
		 * 优惠券最后能领取时间(超过这个时间，优惠券不能领取)
		 */
		@ApiField("apply_end_time")
		private Date applyEndTime;
		/**
		 * 优惠券最早能领取时间(在这时间之前，优惠券不能领取)
		 */
		@ApiField("apply_start_time")
		private Date applyStartTime;
		/**
		 * 优惠券每日限领数（-1表示不限制）
		 */
		@ApiField("coupon_daily_lmt")
		private Long couponDailyLmt;
		/**
		 * 优惠券总数（-1表示不限制）
		 */
		@ApiField("coupon_total_lmt")
		private Long couponTotalLmt;
		/**
		 * 每人每日限领（-1表示不限制）
		 */
		@ApiField("personal_daily_lmt")
		private Long personalDailyLmt;
		/**
		 * 个人总领取限制数量（-1表示不限制）
		 */
		@ApiField("personal_lmt")
		private Long personalLmt;
	

	public Date getApplyEndTime() {
			return this.applyEndTime;
		}
		public void setApplyEndTime(Date applyEndTime) {
			this.applyEndTime = applyEndTime;
		}
		public Date getApplyStartTime() {
			return this.applyStartTime;
		}
		public void setApplyStartTime(Date applyStartTime) {
			this.applyStartTime = applyStartTime;
		}
		public Long getCouponDailyLmt() {
			return this.couponDailyLmt;
		}
		public void setCouponDailyLmt(Long couponDailyLmt) {
			this.couponDailyLmt = couponDailyLmt;
		}
		public Long getCouponTotalLmt() {
			return this.couponTotalLmt;
		}
		public void setCouponTotalLmt(Long couponTotalLmt) {
			this.couponTotalLmt = couponTotalLmt;
		}
		public Long getPersonalDailyLmt() {
			return this.personalDailyLmt;
		}
		public void setPersonalDailyLmt(Long personalDailyLmt) {
			this.personalDailyLmt = personalDailyLmt;
		}
		public Long getPersonalLmt() {
			return this.personalLmt;
		}
		public void setPersonalLmt(Long personalLmt) {
			this.personalLmt = personalLmt;
		}

}

	/**
 * 基础信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateCommonConfig extends TaobaoObject {

	private static final long serialVersionUID = 8567119784791591468L;

	/**
		 * 申请渠道 anonymousOffline
		 */
		@ApiListField("apply_channels")
		@ApiField("string")
		private List<String> applyChannels;
		/**
		 * 优惠券活动描述
		 */
		@ApiField("description")
		private String description;
		/**
		 * 优惠券发放方式 ANONYMOUS("anonymous","匿名券"), REGISTERED("registered","记名券"),
		 */
		@ApiField("send_type")
		private String sendType;
		/**
		 * 模板状态 NORMAL(1, "有效"), DELETE(-1, "删除"), ENDING(0, "结束领取"), NOUSE(-2, "无效"), WDK_COUPON_DRAFT(-999, "草稿"),
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 优惠券名称
		 */
		@ApiField("title")
		private String title;
		/**
		 * 优惠券类型 UNIT_PRICE(10,"unitPrice","单品定价券"), FULL_AMOUNT_REDUCE(11, "fullAmountReduce", "满元减券"), FULL_AMOUNT_DISCOUNT(12, "fullAmountDiscount", "满元折券"), FULL_COUNT_REDUCE(13, "fullCountReduce", "满件减券"), FULL_COUNT_DISCOUNT(14, "fullCountDiscount", "满件折券"), VOUCHER(15, "voucher", "抵用券"),
		 */
		@ApiField("type")
		private Long type;
	

	public List<String> getApplyChannels() {
			return this.applyChannels;
		}
		public void setApplyChannels(List<String> applyChannels) {
			this.applyChannels = applyChannels;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getSendType() {
			return this.sendType;
		}
		public void setSendType(String sendType) {
			this.sendType = sendType;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}

}

	/**
 * 人群信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateUserCrowdConfig extends TaobaoObject {

	private static final long serialVersionUID = 2479253574774712296L;

	/**
		 * 商家自定义人群
		 */
		@ApiField("merchant_customize_crowd_name")
		private String merchantCustomizeCrowdName;
		/**
		 * 平台人群
		 */
		@ApiField("platform_crowd_name")
		private String platformCrowdName;
	

	public String getMerchantCustomizeCrowdName() {
			return this.merchantCustomizeCrowdName;
		}
		public void setMerchantCustomizeCrowdName(String merchantCustomizeCrowdName) {
			this.merchantCustomizeCrowdName = merchantCustomizeCrowdName;
		}
		public String getPlatformCrowdName() {
			return this.platformCrowdName;
		}
		public void setPlatformCrowdName(String platformCrowdName) {
			this.platformCrowdName = platformCrowdName;
		}

}

	/**
 * 生效条件
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateConditionConfig extends TaobaoObject {

	private static final long serialVersionUID = 8238716763972218948L;

	/**
		 * 门槛金额
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 是否生效满元条件
		 */
		@ApiField("amount_at")
		private Boolean amountAt;
		/**
		 * 生效类目
		 */
		@ApiListField("categories")
		@ApiField("string")
		private List<String> categories;
		/**
		 * 门槛件数
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 是否生效满件条件
		 */
		@ApiField("count_at")
		private Boolean countAt;
		/**
		 * 排除的商品规则 1:专柜品
		 */
		@ApiListField("exclude_item_rules")
		@ApiField("number")
		private List<Long> excludeItemRules;
		/**
		 * 最大优惠金额
		 */
		@ApiField("max_effect_amount")
		private Long maxEffectAmount;
		/**
		 * 单笔订单最大可用张数
		 */
		@ApiField("max_use_count_per_order")
		private Long maxUseCountPerOrder;
		/**
		 * 生效商家类目
		 */
		@ApiListField("merchant_categories")
		@ApiField("string")
		private List<String> merchantCategories;
		/**
		 * 是否限制本人使用
		 */
		@ApiField("only_member_self")
		private Boolean onlyMemberSelf;
		/**
		 * 券的使用范围 COUPON_RANGE_STORE(1, "rangeShop", "店铺券"), COUPON_RANGE_ITEM(2, "rangeItem", "商品券"), COUPON_RANGE_CATEGORY(3, "rangeCategory", "品类券"), COUPON_RANGE_SELLER(307,"rangeSeller", "卖家券"),
		 */
		@ApiField("range_type")
		private Long rangeType;
		/**
		 * 生效门店
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 生效终端:  1.app 2.pos
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 人群信息
		 */
		@ApiField("user_crowd_config")
		private CouponTemplateUserCrowdConfig userCrowdConfig;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public Boolean getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Boolean amountAt) {
			this.amountAt = amountAt;
		}
		public List<String> getCategories() {
			return this.categories;
		}
		public void setCategories(List<String> categories) {
			this.categories = categories;
		}
		public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public Boolean getCountAt() {
			return this.countAt;
		}
		public void setCountAt(Boolean countAt) {
			this.countAt = countAt;
		}
		public List<Long> getExcludeItemRules() {
			return this.excludeItemRules;
		}
		public void setExcludeItemRules(List<Long> excludeItemRules) {
			this.excludeItemRules = excludeItemRules;
		}
		public Long getMaxEffectAmount() {
			return this.maxEffectAmount;
		}
		public void setMaxEffectAmount(Long maxEffectAmount) {
			this.maxEffectAmount = maxEffectAmount;
		}
		public Long getMaxUseCountPerOrder() {
			return this.maxUseCountPerOrder;
		}
		public void setMaxUseCountPerOrder(Long maxUseCountPerOrder) {
			this.maxUseCountPerOrder = maxUseCountPerOrder;
		}
		public List<String> getMerchantCategories() {
			return this.merchantCategories;
		}
		public void setMerchantCategories(List<String> merchantCategories) {
			this.merchantCategories = merchantCategories;
		}
		public Boolean getOnlyMemberSelf() {
			return this.onlyMemberSelf;
		}
		public void setOnlyMemberSelf(Boolean onlyMemberSelf) {
			this.onlyMemberSelf = onlyMemberSelf;
		}
		public Long getRangeType() {
			return this.rangeType;
		}
		public void setRangeType(Long rangeType) {
			this.rangeType = rangeType;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public CouponTemplateUserCrowdConfig getUserCrowdConfig() {
			return this.userCrowdConfig;
		}
		public void setUserCrowdConfig(CouponTemplateUserCrowdConfig userCrowdConfig) {
			this.userCrowdConfig = userCrowdConfig;
		}

}

	/**
 * 优惠效果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateDiscountConfig extends TaobaoObject {

	private static final long serialVersionUID = 3131849713172647251L;

	/**
		 * 是否减钱
		 */
		@ApiField("decrease")
		private Boolean decrease;
		/**
		 * 减钱金额
		 */
		@ApiField("decrease_money")
		private Long decreaseMoney;
		/**
		 * 是否打折
		 */
		@ApiField("discount")
		private Boolean discount;
		/**
		 * 打折额度
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 是否固定价格
		 */
		@ApiField("fix_price")
		private Boolean fixPrice;
		/**
		 * 优惠后的固定价格
		 */
		@ApiField("fix_price_amount")
		private Long fixPriceAmount;
	

	public Boolean getDecrease() {
			return this.decrease;
		}
		public void setDecrease(Boolean decrease) {
			this.decrease = decrease;
		}
		public Long getDecreaseMoney() {
			return this.decreaseMoney;
		}
		public void setDecreaseMoney(Long decreaseMoney) {
			this.decreaseMoney = decreaseMoney;
		}
		public Boolean getDiscount() {
			return this.discount;
		}
		public void setDiscount(Boolean discount) {
			this.discount = discount;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Boolean getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Boolean fixPrice) {
			this.fixPrice = fixPrice;
		}
		public Long getFixPriceAmount() {
			return this.fixPriceAmount;
		}
		public void setFixPriceAmount(Long fixPriceAmount) {
			this.fixPriceAmount = fixPriceAmount;
		}

}

	/**
 * 出资人配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InvestmentInfo extends TaobaoObject {

	private static final long serialVersionUID = 8872174829746471752L;

	/**
		 * 出资人
		 */
		@ApiField("investor")
		private String investor;
		/**
		 * 出资比例 2000 = 20%
		 */
		@ApiField("investor_ratio")
		private Long investorRatio;
	

	public String getInvestor() {
			return this.investor;
		}
		public void setInvestor(String investor) {
			this.investor = investor;
		}
		public Long getInvestorRatio() {
			return this.investorRatio;
		}
		public void setInvestorRatio(Long investorRatio) {
			this.investorRatio = investorRatio;
		}

}

	/**
 * 出资人配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateInvestmentConfig extends TaobaoObject {

	private static final long serialVersionUID = 1734279968577867373L;

	/**
		 * 出资人配置
		 */
		@ApiListField("investment_info_list")
		@ApiField("investment_info")
		private List<InvestmentInfo> investmentInfoList;
	

	public List<InvestmentInfo> getInvestmentInfoList() {
			return this.investmentInfoList;
		}
		public void setInvestmentInfoList(List<InvestmentInfo> investmentInfoList) {
			this.investmentInfoList = investmentInfoList;
		}

}

	/**
 * 其他配置--拓展信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateOptionConfig extends TaobaoObject {

	private static final long serialVersionUID = 2639187341781633378L;

	/**
		 * 合同ID
		 */
		@ApiField("contract_instance_id")
		private Long contractInstanceId;
		/**
		 * 优惠券logo url
		 */
		@ApiField("logo_url")
		private String logoUrl;
		/**
		 * 外部优惠券模板id
		 */
		@ApiField("out_coupon_template_id")
		private String outCouponTemplateId;
		/**
		 * 外部优惠券类型
		 */
		@ApiField("out_coupon_type")
		private String outCouponType;
		/**
		 * 券图片
		 */
		@ApiField("picture_url")
		private String pictureUrl;
		/**
		 * 采买者ID
		 */
		@ApiField("purchase_id")
		private Long purchaseId;
	

	public Long getContractInstanceId() {
			return this.contractInstanceId;
		}
		public void setContractInstanceId(Long contractInstanceId) {
			this.contractInstanceId = contractInstanceId;
		}
		public String getLogoUrl() {
			return this.logoUrl;
		}
		public void setLogoUrl(String logoUrl) {
			this.logoUrl = logoUrl;
		}
		public String getOutCouponTemplateId() {
			return this.outCouponTemplateId;
		}
		public void setOutCouponTemplateId(String outCouponTemplateId) {
			this.outCouponTemplateId = outCouponTemplateId;
		}
		public String getOutCouponType() {
			return this.outCouponType;
		}
		public void setOutCouponType(String outCouponType) {
			this.outCouponType = outCouponType;
		}
		public String getPictureUrl() {
			return this.pictureUrl;
		}
		public void setPictureUrl(String pictureUrl) {
			this.pictureUrl = pictureUrl;
		}
		public Long getPurchaseId() {
			return this.purchaseId;
		}
		public void setPurchaseId(Long purchaseId) {
			this.purchaseId = purchaseId;
		}

}

	/**
 * 参与者列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LogicGroup extends TaobaoObject {

	private static final long serialVersionUID = 7712339272992217844L;

	/**
		 * 逻辑分组类型  COMMON(1, "普通分组"), EXCHANGE(2, "换购分组"), BUY_GIFT(3, "买赠分组"), EXCHANGE_TJ_OVERLAY(4, "特价换购叠加分组"),
		 */
		@ApiField("logic_group_type")
		private Long logicGroupType;
		/**
		 * 参与者分组序号
		 */
		@ApiField("number")
		private Long number;
		/**
		 * 五道口参与者名称
		 */
		@ApiField("wdk_group_name")
		private String wdkGroupName;
	

	public Long getLogicGroupType() {
			return this.logicGroupType;
		}
		public void setLogicGroupType(Long logicGroupType) {
			this.logicGroupType = logicGroupType;
		}
		public Long getNumber() {
			return this.number;
		}
		public void setNumber(Long number) {
			this.number = number;
		}
		public String getWdkGroupName() {
			return this.wdkGroupName;
		}
		public void setWdkGroupName(String wdkGroupName) {
			this.wdkGroupName = wdkGroupName;
		}

}

	/**
 * 参与者
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateParticipateConfig extends TaobaoObject {

	private static final long serialVersionUID = 7832448934919532973L;

	/**
		 * 参与者列表
		 */
		@ApiListField("participate_list")
		@ApiField("logic_group")
		private List<LogicGroup> participateList;
	

	public List<LogicGroup> getParticipateList() {
			return this.participateList;
		}
		public void setParticipateList(List<LogicGroup> participateList) {
			this.participateList = participateList;
		}

}

	/**
 * 实例有效时间配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateTimeLimitConfig extends TaobaoObject {

	private static final long serialVersionUID = 7124557579259237482L;

	/**
		 * 优惠券结束时间
		 */
		@ApiField("end_valid_time")
		private Date endValidTime;
		/**
		 * 优惠券开始时间
		 */
		@ApiField("start_valid_time")
		private Date startValidTime;
		/**
		 * 优惠券有效时间类型 RANGE(1,"开始结束时间"), DURATION(2,"固定时长"),BETWEEN(4, "发放后X-Y天失效")
		 */
		@ApiField("valid_time_type")
		private Long validTimeType;
		/**
		 * 优惠券有效结束时长，单位为秒（优惠券领取后X-Y天有效的Y）
		 */
		@ApiField("validity_end_interval")
		private Long validityEndInterval;
		/**
		 * 优惠券有效时长，单位为秒（固定有效时长的优惠券）
		 */
		@ApiField("validity_period")
		private Long validityPeriod;
		/**
		 * 优惠券有效开始时长，单位为秒（优惠券领取后X天开始有效）
		 */
		@ApiField("validity_start_interval")
		private Long validityStartInterval;
	

	public Date getEndValidTime() {
			return this.endValidTime;
		}
		public void setEndValidTime(Date endValidTime) {
			this.endValidTime = endValidTime;
		}
		public Date getStartValidTime() {
			return this.startValidTime;
		}
		public void setStartValidTime(Date startValidTime) {
			this.startValidTime = startValidTime;
		}
		public Long getValidTimeType() {
			return this.validTimeType;
		}
		public void setValidTimeType(Long validTimeType) {
			this.validTimeType = validTimeType;
		}
		public Long getValidityEndInterval() {
			return this.validityEndInterval;
		}
		public void setValidityEndInterval(Long validityEndInterval) {
			this.validityEndInterval = validityEndInterval;
		}
		public Long getValidityPeriod() {
			return this.validityPeriod;
		}
		public void setValidityPeriod(Long validityPeriod) {
			this.validityPeriod = validityPeriod;
		}
		public Long getValidityStartInterval() {
			return this.validityStartInterval;
		}
		public void setValidityStartInterval(Long validityStartInterval) {
			this.validityStartInterval = validityStartInterval;
		}

}

	/**
 * 兼容历史逻辑配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateCompatibleConfig extends TaobaoObject {

	private static final long serialVersionUID = 8214346928458949389L;

	/**
		 * 优惠券应用类型 pointCoupon：积分券
		 */
		@ApiField("application_type")
		private String applicationType;
		/**
		 * 是否要求优惠券在一天的23:59:59失效 1表示最后一秒失效
		 */
		@ApiField("valid_till_night")
		private Long validTillNight;
	

	public String getApplicationType() {
			return this.applicationType;
		}
		public void setApplicationType(String applicationType) {
			this.applicationType = applicationType;
		}
		public Long getValidTillNight() {
			return this.validTillNight;
		}
		public void setValidTillNight(Long validTillNight) {
			this.validTillNight = validTillNight;
		}

}

	/**
 * 券模版
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplate extends TaobaoObject {

	private static final long serialVersionUID = 2321243872448449756L;

	/**
		 * 领取限制
		 */
		@ApiField("apply_limit_config")
		private CouponTemplateApplyLimitConfig applyLimitConfig;
		/**
		 * 基础信息
		 */
		@ApiField("common_config")
		private CouponTemplateCommonConfig commonConfig;
		/**
		 * 兼容历史逻辑配置
		 */
		@ApiField("compatible_config")
		private CouponTemplateCompatibleConfig compatibleConfig;
		/**
		 * 生效条件
		 */
		@ApiField("condition_config")
		private CouponTemplateConditionConfig conditionConfig;
		/**
		 * 优惠效果
		 */
		@ApiField("discount_config")
		private CouponTemplateDiscountConfig discountConfig;
		/**
		 * 模板表主键 创建时为空
		 */
		@ApiField("id")
		private Long id;
		/**
		 * 出资人配置
		 */
		@ApiField("investment_config")
		private CouponTemplateInvestmentConfig investmentConfig;
		/**
		 * 其他配置--拓展信息
		 */
		@ApiField("option_config")
		private CouponTemplateOptionConfig optionConfig;
		/**
		 * 参与者
		 */
		@ApiField("participate_config")
		private CouponTemplateParticipateConfig participateConfig;
		/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
		/**
		 * 实例有效时间配置
		 */
		@ApiField("time_limit_config")
		private CouponTemplateTimeLimitConfig timeLimitConfig;
		/**
		 * 幂等id，外部透传
		 */
		@ApiField("unique_id")
		private String uniqueId;
		/**
		 * 优惠券模版uuid
		 */
		@ApiField("uuid")
		private String uuid;
	

	public CouponTemplateApplyLimitConfig getApplyLimitConfig() {
			return this.applyLimitConfig;
		}
		public void setApplyLimitConfig(CouponTemplateApplyLimitConfig applyLimitConfig) {
			this.applyLimitConfig = applyLimitConfig;
		}
		public CouponTemplateCommonConfig getCommonConfig() {
			return this.commonConfig;
		}
		public void setCommonConfig(CouponTemplateCommonConfig commonConfig) {
			this.commonConfig = commonConfig;
		}
		public CouponTemplateCompatibleConfig getCompatibleConfig() {
			return this.compatibleConfig;
		}
		public void setCompatibleConfig(CouponTemplateCompatibleConfig compatibleConfig) {
			this.compatibleConfig = compatibleConfig;
		}
		public CouponTemplateConditionConfig getConditionConfig() {
			return this.conditionConfig;
		}
		public void setConditionConfig(CouponTemplateConditionConfig conditionConfig) {
			this.conditionConfig = conditionConfig;
		}
		public CouponTemplateDiscountConfig getDiscountConfig() {
			return this.discountConfig;
		}
		public void setDiscountConfig(CouponTemplateDiscountConfig discountConfig) {
			this.discountConfig = discountConfig;
		}
		public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public CouponTemplateInvestmentConfig getInvestmentConfig() {
			return this.investmentConfig;
		}
		public void setInvestmentConfig(CouponTemplateInvestmentConfig investmentConfig) {
			this.investmentConfig = investmentConfig;
		}
		public CouponTemplateOptionConfig getOptionConfig() {
			return this.optionConfig;
		}
		public void setOptionConfig(CouponTemplateOptionConfig optionConfig) {
			this.optionConfig = optionConfig;
		}
		public CouponTemplateParticipateConfig getParticipateConfig() {
			return this.participateConfig;
		}
		public void setParticipateConfig(CouponTemplateParticipateConfig participateConfig) {
			this.participateConfig = participateConfig;
		}
		public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}
		public CouponTemplateTimeLimitConfig getTimeLimitConfig() {
			return this.timeLimitConfig;
		}
		public void setTimeLimitConfig(CouponTemplateTimeLimitConfig timeLimitConfig) {
			this.timeLimitConfig = timeLimitConfig;
		}
		public String getUniqueId() {
			return this.uniqueId;
		}
		public void setUniqueId(String uniqueId) {
			this.uniqueId = uniqueId;
		}
		public String getUuid() {
			return this.uuid;
		}
		public void setUuid(String uuid) {
			this.uuid = uuid;
		}

}

	/**
 * 用户信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfo extends TaobaoObject {

	private static final long serialVersionUID = 4479314729277189952L;

	/**
		 * 来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 用户名称
		 */
		@ApiField("user_name")
		private String userName;
	

	public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUserName() {
			return this.userName;
		}
		public void setUserName(String userName) {
			this.userName = userName;
		}

}

	/**
 * 请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateOperateRequest extends TaobaoObject {

	private static final long serialVersionUID = 3347977691422857223L;

	/**
		 * 券模版
		 */
		@ApiField("coupon_template")
		private CouponTemplate couponTemplate;
		/**
		 * 用户信息
		 */
		@ApiField("user_info")
		private UserInfo userInfo;
	

	public CouponTemplate getCouponTemplate() {
			return this.couponTemplate;
		}
		public void setCouponTemplate(CouponTemplate couponTemplate) {
			this.couponTemplate = couponTemplate;
		}
		public UserInfo getUserInfo() {
			return this.userInfo;
		}
		public void setUserInfo(UserInfo userInfo) {
			this.userInfo = userInfo;
		}

}


}