package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponTemplateQueryResponse;

/**
 * TOP API: alibaba.wdk.coupon.template.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.01
 */
public class AlibabaWdkCouponTemplateQueryRequest extends BaseTaobaoRequest<AlibabaWdkCouponTemplateQueryResponse> {
	
	

	/** 
	* 系统自动生成
	 */
	private String paramCouponTemplateQueryRequest;

	public void setParamCouponTemplateQueryRequest(String paramCouponTemplateQueryRequest) {
		this.paramCouponTemplateQueryRequest = paramCouponTemplateQueryRequest;
	}

	public void setParamCouponTemplateQueryRequest(CouponTemplateQueryRequest paramCouponTemplateQueryRequest) {
		this.paramCouponTemplateQueryRequest = new JSONWriter(false,true).write(paramCouponTemplateQueryRequest);
	}

	public String getParamCouponTemplateQueryRequest() {
		return this.paramCouponTemplateQueryRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.template.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_coupon_template_query_request", this.paramCouponTemplateQueryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponTemplateQueryResponse> getResponseClass() {
		return AlibabaWdkCouponTemplateQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 用户信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfo extends TaobaoObject {

	private static final long serialVersionUID = 3748929371933559939L;

	/**
		 * 来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 用户名称
		 */
		@ApiField("user_name")
		private String userName;
	

	public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUserName() {
			return this.userName;
		}
		public void setUserName(String userName) {
			this.userName = userName;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 5721623684571581845L;

	/**
		 * 模板表ID
		 */
		@ApiField("id")
		private Long id;
		/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
		/**
		 * 用户信息
		 */
		@ApiField("user_info")
		private UserInfo userInfo;
	

	public Long getId() {
			return this.id;
		}
		public void setId(Long id) {
			this.id = id;
		}
		public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}
		public UserInfo getUserInfo() {
			return this.userInfo;
		}
		public void setUserInfo(UserInfo userInfo) {
			this.userInfo = userInfo;
		}

}


}