package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaWdkCouponTemplateQueryumpactidResponse;

/**
 * TOP API: alibaba.wdk.coupon.template.queryumpactid request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.22
 */
public class AlibabaWdkCouponTemplateQueryumpactidRequest extends BaseTaobaoRequest<AlibabaWdkCouponTemplateQueryumpactidResponse> {
	
	

	/** 
	* 券模版id列表
	 */
	private String sourceIds;

	/** 
	* 优惠券类型
	 */
	private Long wdkCouponType;

	public void setSourceIds(String sourceIds) {
		this.sourceIds = sourceIds;
	}

	public String getSourceIds() {
		return this.sourceIds;
	}

	public void setWdkCouponType(Long wdkCouponType) {
		this.wdkCouponType = wdkCouponType;
	}

	public Long getWdkCouponType() {
		return this.wdkCouponType;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.template.queryumpactid";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("source_ids", this.sourceIds);
		txtParams.put("wdk_coupon_type", this.wdkCouponType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponTemplateQueryumpactidResponse> getResponseClass() {
		return AlibabaWdkCouponTemplateQueryumpactidResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(sourceIds, "sourceIds");
		RequestCheckUtils.checkMaxListSize(sourceIds, 999, "sourceIds");
		RequestCheckUtils.checkNotEmpty(wdkCouponType, "wdkCouponType");
	}
	

}