package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkCouponTemplateTerminateResponse;

/**
 * TOP API: alibaba.wdk.coupon.template.terminate request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class AlibabaWdkCouponTemplateTerminateRequest extends BaseTaobaoRequest<AlibabaWdkCouponTemplateTerminateResponse> {
	
	

	/** 
	* 参数
	 */
	private String paramCouponTemplateTerminateRequest;

	public void setParamCouponTemplateTerminateRequest(String paramCouponTemplateTerminateRequest) {
		this.paramCouponTemplateTerminateRequest = paramCouponTemplateTerminateRequest;
	}

	public void setParamCouponTemplateTerminateRequest(CouponTemplateTerminateRequest paramCouponTemplateTerminateRequest) {
		this.paramCouponTemplateTerminateRequest = new JSONWriter(false,true).write(paramCouponTemplateTerminateRequest);
	}

	public String getParamCouponTemplateTerminateRequest() {
		return this.paramCouponTemplateTerminateRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.coupon.template.terminate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_coupon_template_terminate_request", this.paramCouponTemplateTerminateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkCouponTemplateTerminateResponse> getResponseClass() {
		return AlibabaWdkCouponTemplateTerminateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 用户信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UserInfo extends TaobaoObject {

	private static final long serialVersionUID = 4517374498591268855L;

	/**
		 * 来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private Long userId;
		/**
		 * 用户名
		 */
		@ApiField("user_name")
		private String userName;
	

	public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Long getUserId() {
			return this.userId;
		}
		public void setUserId(Long userId) {
			this.userId = userId;
		}
		public String getUserName() {
			return this.userName;
		}
		public void setUserName(String userName) {
			this.userName = userName;
		}

}

	/**
 * 参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponTemplateTerminateRequest extends TaobaoObject {

	private static final long serialVersionUID = 1249452252637591351L;

	/**
		 * ump模板ID
		 */
		@ApiField("source_id")
		private Long sourceId;
		/**
		 * 用户信息
		 */
		@ApiField("user_info")
		private UserInfo userInfo;
	

	public Long getSourceId() {
			return this.sourceId;
		}
		public void setSourceId(Long sourceId) {
			this.sourceId = sourceId;
		}
		public UserInfo getUserInfo() {
			return this.userInfo;
		}
		public void setUserInfo(UserInfo userInfo) {
			this.userInfo = userInfo;
		}

}


}