package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingCouponAdditemResponse;

/**
 * TOP API: alibaba.wdk.marketing.coupon.additem request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class AlibabaWdkMarketingCouponAdditemRequest extends BaseTaobaoRequest<AlibabaWdkMarketingCouponAdditemResponse> {
	
	

	/** 
	* 商品对象
	 */
	private String param0;

	/** 
	* 活动基本信息
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemCouponSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.coupon.additem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingCouponAdditemResponse> getResponseClass() {
		return AlibabaWdkMarketingCouponAdditemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 商品对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemCouponSku extends TaobaoObject {

	private static final long serialVersionUID = 8414327158938886786L;

	/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 活动基本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 2536531138119961962L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}