package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingCouponCreateactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.coupon.createactivity request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.08
 */
public class AlibabaWdkMarketingCouponCreateactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingCouponCreateactivityResponse> {
	
	

	/** 
	* 创建优惠券活动请求入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(CouponActivity param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.coupon.createactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingCouponCreateactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingCouponCreateactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制[如果同时设置了(每人活动期间总限领)和(每人每日限领)，则只能生效(每人活动期间总限领)]
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 8262644814632296998L;

	/**
		 * 活动每日总限领
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 必须指定且值为正数，活动期间总限领
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限领
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限领
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 创建优惠券活动请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponActivity extends TaobaoObject {

	private static final long serialVersionUID = 1886926935548351279L;

	/**
		 * 优惠券活动名称,不超过10个中文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 券面额 [单位为分]
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 适用类目
		 */
		@ApiListField("applicable_categories")
		@ApiField("number")
		private List<Long> applicableCategories;
		/**
		 * 优惠券领取渠道 [fullSendCoupon:满额返券;fallingSendCoupon:天降红包;customerService:客服补偿发券;其他渠道请找接口人申请]
		 */
		@ApiListField("apply_channels")
		@ApiField("string")
		private List<String> applyChannels;
		/**
		 * [减至券特有]优惠件数，限制最多优惠N件，值为-1代表不限制优惠件数 [单位为整数]【已下线】
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 优惠券活动描述，不超过100个中文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 自定义的优惠券使用详情(支持多条)
		 */
		@ApiListField("details")
		@ApiField("string")
		private List<String> details;
		/**
		 * 优惠券优惠类型 [fullReduce:满减券;reduceTo:减至券，即一口价券]
		 */
		@ApiField("discount_type")
		private String discountType;
		/**
		 * 活动结束时间，时间戳[ms单位]
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制[如果同时设置了(每人活动期间总限领)和(每人每日限领)，则只能生效(每人活动期间总限领)]
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 优惠券logo url，设置匿名券时为必传参数
		 */
		@ApiField("logo_url")
		private String logoUrl;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 优惠券适用范围 [rangeShop:店铺券;rangeItem:商品;rangeCategory:品类券]
		 */
		@ApiField("range_type")
		private String rangeType;
		/**
		 * 优惠券发放方式 [anonymous:匿名券;registered:记名券]
		 */
		@ApiField("send_type")
		private String sendType;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * [减至券特有]件数门槛，值为-1代表无门槛 [单位为整数]【已下线】
		 */
		@ApiField("start_count")
		private Long startCount;
		/**
		 * [满减券特有，券类型为满减券时为必传参数]金额门槛，值为-1代表无门槛 [单位为分]
		 */
		@ApiField("start_fee")
		private Long startFee;
		/**
		 * 活动开始时间，时间戳[ms单位]
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 领取后N日有效；如果设置了该值，则不需要设置优惠券的开始时间和结束时间 [有效期截止至领取日期+N天的23:59:59。例券设置有效期领取后5天有效，2018.1.1领取的券，有效期截止至2018.1.6 23:59:59； 例券设置有效期领取后0天有效，2018.1.1领取的券，有效期截止至2018.1.1 23:59:59]
		 */
		@ApiField("valid_days")
		private Long validDays;
	

	public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public List<Long> getApplicableCategories() {
			return this.applicableCategories;
		}
		public void setApplicableCategories(List<Long> applicableCategories) {
			this.applicableCategories = applicableCategories;
		}
		public List<String> getApplyChannels() {
			return this.applyChannels;
		}
		public void setApplyChannels(List<String> applyChannels) {
			this.applyChannels = applyChannels;
		}
		public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public List<String> getDetails() {
			return this.details;
		}
		public void setDetails(List<String> details) {
			this.details = details;
		}
		public String getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(String discountType) {
			this.discountType = discountType;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getLogoUrl() {
			return this.logoUrl;
		}
		public void setLogoUrl(String logoUrl) {
			this.logoUrl = logoUrl;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public String getRangeType() {
			return this.rangeType;
		}
		public void setRangeType(String rangeType) {
			this.rangeType = rangeType;
		}
		public String getSendType() {
			return this.sendType;
		}
		public void setSendType(String sendType) {
			this.sendType = sendType;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartCount() {
			return this.startCount;
		}
		public void setStartCount(Long startCount) {
			this.startCount = startCount;
		}
		public Long getStartFee() {
			return this.startFee;
		}
		public void setStartFee(Long startFee) {
			this.startFee = startFee;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public Long getValidDays() {
			return this.validDays;
		}
		public void setValidDays(Long validDays) {
			this.validDays = validDays;
		}

}


}