package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingCouponQueryactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.coupon.queryactivity request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class AlibabaWdkMarketingCouponQueryactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingCouponQueryactivityResponse> {
	
	

	/** 
	* 查询优惠券活动入参
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(CommonActivityParam param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.coupon.queryactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingCouponQueryactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingCouponQueryactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询优惠券活动入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 5127179331181337839L;

	/**
		 * 五道口优惠券活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家优惠券活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}