package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingDiscountItemRemoveAsyncResponse;

/**
 * TOP API: alibaba.wdk.marketing.discount.item.remove.async request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.21
 */
public class AlibabaWdkMarketingDiscountItemRemoveAsyncRequest extends BaseTaobaoRequest<AlibabaWdkMarketingDiscountItemRemoveAsyncResponse> {
	
	

	/** 
	* sku信息
	 */
	private String param0;

	/** 
	* 系统自动生成
	 */
	private String param1;

	/** 
	* alibaba.wdk.marketing.version.generate接口生成
	 */
	private Long version;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(List<ItemDiscountSku> param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public void setVersion(Long version) {
		this.version = version;
	}

	public Long getVersion() {
		return this.version;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.discount.item.remove.async";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		txtParams.put("version", this.version);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingDiscountItemRemoveAsyncResponse> getResponseClass() {
		return AlibabaWdkMarketingDiscountItemRemoveAsyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(param0, 20, "param0");
		RequestCheckUtils.checkNotEmpty(version, "version");
	}
	
	/**
 * sku信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemDiscountSku extends TaobaoObject {

	private static final long serialVersionUID = 7412147674932115768L;

	/**
		 * 商品的skuCode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 3367879493429485279L;

	/**
		 * 活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 外部活动编码
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}