package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingExpirePromotionDeleteResponse;

/**
 * TOP API: alibaba.wdk.marketing.expire.promotion.delete request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingExpirePromotionDeleteRequest extends BaseTaobaoRequest<AlibabaWdkMarketingExpirePromotionDeleteResponse> {
	
	

	/** 
	* 删除短保优惠
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ExpirePromotionBo param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.expire.promotion.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingExpirePromotionDeleteResponse> getResponseClass() {
		return AlibabaWdkMarketingExpirePromotionDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 短保时间段信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExpirePeriodInfo extends TaobaoObject {

	private static final long serialVersionUID = 7383826611452733797L;

	/**
		 * 0到24，小时数值
		 */
		@ApiField("end_hour")
		private Long endHour;
		/**
		 * 外部活动id
		 */
		@ApiField("out_id")
		private Long outId;
		/**
		 * 优惠具体折扣，1到1000
		 */
		@ApiField("promotion_value")
		private Long promotionValue;
		/**
		 * 0到24，小时数值
		 */
		@ApiField("start_hour")
		private Long startHour;
	

	public Long getEndHour() {
			return this.endHour;
		}
		public void setEndHour(Long endHour) {
			this.endHour = endHour;
		}
		public Long getOutId() {
			return this.outId;
		}
		public void setOutId(Long outId) {
			this.outId = outId;
		}
		public Long getPromotionValue() {
			return this.promotionValue;
		}
		public void setPromotionValue(Long promotionValue) {
			this.promotionValue = promotionValue;
		}
		public Long getStartHour() {
			return this.startHour;
		}
		public void setStartHour(Long startHour) {
			this.startHour = startHour;
		}

}

	/**
 * 删除短保优惠
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExpirePromotionBo extends TaobaoObject {

	private static final long serialVersionUID = 1175251582653364358L;

	/**
		 * 短保时间段信息
		 */
		@ApiListField("period_infos")
		@ApiField("expire_period_info")
		private List<ExpirePeriodInfo> periodInfos;
		/**
		 * 门店id
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 商品skucode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public List<ExpirePeriodInfo> getPeriodInfos() {
			return this.periodInfos;
		}
		public void setPeriodInfos(List<ExpirePeriodInfo> periodInfos) {
			this.periodInfos = periodInfos;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}


}