package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingFullrangeCreateactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.fullrange.createactivity request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingFullrangeCreateactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingFullrangeCreateactivityResponse> {
	
	

	/** 
	* 创建活动请求入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(FullRangeActivity param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.fullrange.createactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingFullrangeCreateactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingFullrangeCreateactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 7218586664288457669L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 活动的梯度列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Rulestairs extends TaobaoObject {

	private static final long serialVersionUID = 7236262277629839929L;

	/**
		 * 满多少元[单位为分，传入700，代表满7元]，amountAt为true时，必须设置
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 是否使用满元条件，不能与满件、N件Y折同时使用。此选项为true时，countAt和countBegin必须为false
		 */
		@ApiField("amount_at")
		private Boolean amountAt;
		/**
		 * 可换购的数量
		 */
		@ApiField("can_extra_item_num")
		private Long canExtraItemNum;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public Boolean getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Boolean amountAt) {
			this.amountAt = amountAt;
		}
		public Long getCanExtraItemNum() {
			return this.canExtraItemNum;
		}
		public void setCanExtraItemNum(Long canExtraItemNum) {
			this.canExtraItemNum = canExtraItemNum;
		}

}

	/**
 * 创建活动请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class FullRangeActivity extends TaobaoObject {

	private static final long serialVersionUID = 7585119848346511358L;

	/**
		 * 活动名称,不超过10个英文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 活动详情描述,不超过30个英文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 活动结束时间，时间戳
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 活动的梯度列表
		 */
		@ApiListField("rule_stairs")
		@ApiField("rulestairs")
		private List<Rulestairs> ruleStairs;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 活动开始时间，时间戳
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public List<Rulestairs> getRuleStairs() {
			return this.ruleStairs;
		}
		public void setRuleStairs(List<Rulestairs> ruleStairs) {
			this.ruleStairs = ruleStairs;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}


}