package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingFullrangeRemoveitemResponse;

/**
 * TOP API: alibaba.wdk.marketing.fullrange.removeitem request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingFullrangeRemoveitemRequest extends BaseTaobaoRequest<AlibabaWdkMarketingFullrangeRemoveitemResponse> {
	
	

	/** 
	* 商品sku信息
	 */
	private String param0;

	/** 
	* 活动信息
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemStairSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.fullrange.removeitem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingFullrangeRemoveitemResponse> getResponseClass() {
		return AlibabaWdkMarketingFullrangeRemoveitemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 商品sku信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemStairSku extends TaobaoObject {

	private static final long serialVersionUID = 4382255385847771781L;

	/**
		 * 商品skucode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 活动信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 1468353829238998993L;

	/**
		 * 报名活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}