package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItembuygiftDeleteactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.itembuygift.deleteactivity request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.19
 */
public class AlibabaWdkMarketingItembuygiftDeleteactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItembuygiftDeleteactivityResponse> {
	
	

	/** 
	* 要删除的活动信息
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(CommonActivityParam param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itembuygift.deleteactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItembuygiftDeleteactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingItembuygiftDeleteactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 要删除的活动信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 2529859824724744872L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家的活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}