package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItembuygiftQueryactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.itembuygift.queryactivity request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.19
 */
public class AlibabaWdkMarketingItembuygiftQueryactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItembuygiftQueryactivityResponse> {
	
	

	/** 
	* 查询入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(CommonActivityParam param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itembuygift.queryactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItembuygiftQueryactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingItembuygiftQueryactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 1361753867681314951L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}