package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItembuygiftQueryitemsResponse;

/**
 * TOP API: alibaba.wdk.marketing.itembuygift.queryitems request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.19
 */
public class AlibabaWdkMarketingItembuygiftQueryitemsRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItembuygiftQueryitemsResponse> {
	
	

	/** 
	* 查询入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(ActivitySkuQuery param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itembuygift.queryitems";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItembuygiftQueryitemsResponse> getResponseClass() {
		return AlibabaWdkMarketingItembuygiftQueryitemsResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 分页信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BasePageQuery extends TaobaoObject {

	private static final long serialVersionUID = 5567268215991768356L;

	/**
		 * 当前分页，从1开始
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}

	/**
 * 查询入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivitySkuQuery extends TaobaoObject {

	private static final long serialVersionUID = 4665172136488541476L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 分页信息
		 */
		@ApiField("page")
		private BasePageQuery page;
		/**
		 * 需要查询的商品skuCodes
		 */
		@ApiListField("sku_codes")
		@ApiField("string")
		private List<String> skuCodes;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public BasePageQuery getPage() {
			return this.page;
		}
		public void setPage(BasePageQuery page) {
			this.page = page;
		}
		public List<String> getSkuCodes() {
			return this.skuCodes;
		}
		public void setSkuCodes(List<String> skuCodes) {
			this.skuCodes = skuCodes;
		}

}


}