package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItemdiscountQueryitemsResponse;

/**
 * TOP API: alibaba.wdk.marketing.itemdiscount.queryitems request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.19
 */
public class AlibabaWdkMarketingItemdiscountQueryitemsRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItemdiscountQueryitemsResponse> {
	
	

	/** 
	* 查询入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(ActivitySkuQuery param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itemdiscount.queryitems";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItemdiscountQueryitemsResponse> getResponseClass() {
		return AlibabaWdkMarketingItemdiscountQueryitemsResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 分页参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BasePageQuery extends TaobaoObject {

	private static final long serialVersionUID = 3235234798842478321L;

	/**
		 * 当前分页，从1开始
		 */
		@ApiField("current")
		private Long current;
		/**
		 * 页面大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getCurrent() {
			return this.current;
		}
		public void setCurrent(Long current) {
			this.current = current;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}

	/**
 * 自定义同步的渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 3636552242948115213L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 查询入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivitySkuQuery extends TaobaoObject {

	private static final long serialVersionUID = 7571491362899328946L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步的渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 分页参数
		 */
		@ApiField("page")
		private BasePageQuery page;
		/**
		 * 需要查询的商品skuCodes
		 */
		@ApiListField("sku_codes")
		@ApiField("string")
		private List<String> skuCodes;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public BasePageQuery getPage() {
			return this.page;
		}
		public void setPage(BasePageQuery page) {
			this.page = page;
		}
		public List<String> getSkuCodes() {
			return this.skuCodes;
		}
		public void setSkuCodes(List<String> skuCodes) {
			this.skuCodes = skuCodes;
		}

}


}