package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItempoolActivityCreateResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.activity.create request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingItempoolActivityCreateRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItempoolActivityCreateResponse> {
	
	

	/** 
	* 创建活动请求入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(ItemPoolActivity param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itempool.activity.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItempoolActivityCreateResponse> getResponseClass() {
		return AlibabaWdkMarketingItempoolActivityCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 1422212661758434362L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 指定件数优惠规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CapCountDiscountRule extends TaobaoObject {

	private static final long serialVersionUID = 3813526674527374514L;

	/**
		 * 指定件数整体减钱【分】
		 */
		@ApiField("cap_count_decrease_money")
		private Long capCountDecreaseMoney;
		/**
		 * 指定件数整体打几折【600=6折】
		 */
		@ApiField("cap_count_discount_rate")
		private Long capCountDiscountRate;
		/**
		 * 指定件数每件一口价【分】
		 */
		@ApiField("cap_count_each_fix_price")
		private Long capCountEachFixPrice;
		/**
		 * 指定件数整体一口价【分】
		 */
		@ApiField("cap_count_fix_price")
		private Long capCountFixPrice;
		/**
		 * 是否指定件数整体减钱
		 */
		@ApiField("is_cap_count_decrease_money")
		private Boolean isCapCountDecreaseMoney;
		/**
		 * 是否指定件数整体打折
		 */
		@ApiField("is_cap_count_discount_rate")
		private Boolean isCapCountDiscountRate;
		/**
		 * 是否指定件数每件一口价
		 */
		@ApiField("is_cap_count_each_fix_price")
		private Boolean isCapCountEachFixPrice;
		/**
		 * 是否指定件数整体一口价
		 */
		@ApiField("is_cap_count_fix_price")
		private Boolean isCapCountFixPrice;
	

	public Long getCapCountDecreaseMoney() {
			return this.capCountDecreaseMoney;
		}
		public void setCapCountDecreaseMoney(Long capCountDecreaseMoney) {
			this.capCountDecreaseMoney = capCountDecreaseMoney;
		}
		public Long getCapCountDiscountRate() {
			return this.capCountDiscountRate;
		}
		public void setCapCountDiscountRate(Long capCountDiscountRate) {
			this.capCountDiscountRate = capCountDiscountRate;
		}
		public Long getCapCountEachFixPrice() {
			return this.capCountEachFixPrice;
		}
		public void setCapCountEachFixPrice(Long capCountEachFixPrice) {
			this.capCountEachFixPrice = capCountEachFixPrice;
		}
		public Long getCapCountFixPrice() {
			return this.capCountFixPrice;
		}
		public void setCapCountFixPrice(Long capCountFixPrice) {
			this.capCountFixPrice = capCountFixPrice;
		}
		public Boolean getIsCapCountDecreaseMoney() {
			return this.isCapCountDecreaseMoney;
		}
		public void setIsCapCountDecreaseMoney(Boolean isCapCountDecreaseMoney) {
			this.isCapCountDecreaseMoney = isCapCountDecreaseMoney;
		}
		public Boolean getIsCapCountDiscountRate() {
			return this.isCapCountDiscountRate;
		}
		public void setIsCapCountDiscountRate(Boolean isCapCountDiscountRate) {
			this.isCapCountDiscountRate = isCapCountDiscountRate;
		}
		public Boolean getIsCapCountEachFixPrice() {
			return this.isCapCountEachFixPrice;
		}
		public void setIsCapCountEachFixPrice(Boolean isCapCountEachFixPrice) {
			this.isCapCountEachFixPrice = isCapCountEachFixPrice;
		}
		public Boolean getIsCapCountFixPrice() {
			return this.isCapCountFixPrice;
		}
		public void setIsCapCountFixPrice(Boolean isCapCountFixPrice) {
			this.isCapCountFixPrice = isCapCountFixPrice;
		}

}

	/**
 * 阶梯整体优惠规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CoverAllDiscountRule extends TaobaoObject {

	private static final long serialVersionUID = 5264826425183638463L;

	/**
		 * 整体减钱【分】
		 */
		@ApiField("cover_all_decrease_money")
		private Long coverAllDecreaseMoney;
		/**
		 * 整体打折【600=6折】
		 */
		@ApiField("cover_all_discount_rate")
		private Long coverAllDiscountRate;
		/**
		 * 整体一口价【分】
		 */
		@ApiField("cover_all_fix_price")
		private Long coverAllFixPrice;
		/**
		 * 每件商品一口价【分】
		 */
		@ApiField("each_fix_price")
		private Long eachFixPrice;
		/**
		 * 是否整体减钱
		 */
		@ApiField("is_cover_all_decrease_money")
		private Boolean isCoverAllDecreaseMoney;
		/**
		 * 是否整体打折
		 */
		@ApiField("is_cover_all_discount_rate")
		private Boolean isCoverAllDiscountRate;
		/**
		 * 是否整体一口价
		 */
		@ApiField("is_cover_all_fix_price")
		private Boolean isCoverAllFixPrice;
		/**
		 * 是否每件一口价
		 */
		@ApiField("is_each_fix_price")
		private Boolean isEachFixPrice;
	

	public Long getCoverAllDecreaseMoney() {
			return this.coverAllDecreaseMoney;
		}
		public void setCoverAllDecreaseMoney(Long coverAllDecreaseMoney) {
			this.coverAllDecreaseMoney = coverAllDecreaseMoney;
		}
		public Long getCoverAllDiscountRate() {
			return this.coverAllDiscountRate;
		}
		public void setCoverAllDiscountRate(Long coverAllDiscountRate) {
			this.coverAllDiscountRate = coverAllDiscountRate;
		}
		public Long getCoverAllFixPrice() {
			return this.coverAllFixPrice;
		}
		public void setCoverAllFixPrice(Long coverAllFixPrice) {
			this.coverAllFixPrice = coverAllFixPrice;
		}
		public Long getEachFixPrice() {
			return this.eachFixPrice;
		}
		public void setEachFixPrice(Long eachFixPrice) {
			this.eachFixPrice = eachFixPrice;
		}
		public Boolean getIsCoverAllDecreaseMoney() {
			return this.isCoverAllDecreaseMoney;
		}
		public void setIsCoverAllDecreaseMoney(Boolean isCoverAllDecreaseMoney) {
			this.isCoverAllDecreaseMoney = isCoverAllDecreaseMoney;
		}
		public Boolean getIsCoverAllDiscountRate() {
			return this.isCoverAllDiscountRate;
		}
		public void setIsCoverAllDiscountRate(Boolean isCoverAllDiscountRate) {
			this.isCoverAllDiscountRate = isCoverAllDiscountRate;
		}
		public Boolean getIsCoverAllFixPrice() {
			return this.isCoverAllFixPrice;
		}
		public void setIsCoverAllFixPrice(Boolean isCoverAllFixPrice) {
			this.isCoverAllFixPrice = isCoverAllFixPrice;
		}
		public Boolean getIsEachFixPrice() {
			return this.isEachFixPrice;
		}
		public void setIsEachFixPrice(Boolean isEachFixPrice) {
			this.isEachFixPrice = isEachFixPrice;
		}

}

	/**
 * 第N件优惠规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CountAtDiscountRule extends TaobaoObject {

	private static final long serialVersionUID = 4396626984775839943L;

	/**
		 * 第N件减钱【分】
		 */
		@ApiField("count_at_decrease_money")
		private Long countAtDecreaseMoney;
		/**
		 * 第N件折扣率【600=6折】
		 */
		@ApiField("count_at_discount_rate")
		private Long countAtDiscountRate;
		/**
		 * 第N件一口价【分】
		 */
		@ApiField("count_at_fix_price")
		private Long countAtFixPrice;
		/**
		 * 是否第N件减钱
		 */
		@ApiField("is_count_at_decrease_money")
		private Boolean isCountAtDecreaseMoney;
		/**
		 * 是否第N件打折
		 */
		@ApiField("is_count_at_discount_rate")
		private Boolean isCountAtDiscountRate;
		/**
		 * 是否第N建一口价
		 */
		@ApiField("is_count_at_fix_price")
		private Boolean isCountAtFixPrice;
	

	public Long getCountAtDecreaseMoney() {
			return this.countAtDecreaseMoney;
		}
		public void setCountAtDecreaseMoney(Long countAtDecreaseMoney) {
			this.countAtDecreaseMoney = countAtDecreaseMoney;
		}
		public Long getCountAtDiscountRate() {
			return this.countAtDiscountRate;
		}
		public void setCountAtDiscountRate(Long countAtDiscountRate) {
			this.countAtDiscountRate = countAtDiscountRate;
		}
		public Long getCountAtFixPrice() {
			return this.countAtFixPrice;
		}
		public void setCountAtFixPrice(Long countAtFixPrice) {
			this.countAtFixPrice = countAtFixPrice;
		}
		public Boolean getIsCountAtDecreaseMoney() {
			return this.isCountAtDecreaseMoney;
		}
		public void setIsCountAtDecreaseMoney(Boolean isCountAtDecreaseMoney) {
			this.isCountAtDecreaseMoney = isCountAtDecreaseMoney;
		}
		public Boolean getIsCountAtDiscountRate() {
			return this.isCountAtDiscountRate;
		}
		public void setIsCountAtDiscountRate(Boolean isCountAtDiscountRate) {
			this.isCountAtDiscountRate = isCountAtDiscountRate;
		}
		public Boolean getIsCountAtFixPrice() {
			return this.isCountAtFixPrice;
		}
		public void setIsCountAtFixPrice(Boolean isCountAtFixPrice) {
			this.isCountAtFixPrice = isCountAtFixPrice;
		}

}

	/**
 * 单独定价优惠规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SeparatePricingDiscountRule extends TaobaoObject {

	private static final long serialVersionUID = 6356466961688413638L;

	/**
		 * 是否为减钱类型
		 */
		@ApiField("is_decrease")
		private Boolean isDecrease;
		/**
		 * 是否为打折类型
		 */
		@ApiField("is_discount_rate")
		private Boolean isDiscountRate;
		/**
		 * 是否为一口价类型
		 */
		@ApiField("is_fix_price")
		private Boolean isFixPrice;
	

	public Boolean getIsDecrease() {
			return this.isDecrease;
		}
		public void setIsDecrease(Boolean isDecrease) {
			this.isDecrease = isDecrease;
		}
		public Boolean getIsDiscountRate() {
			return this.isDiscountRate;
		}
		public void setIsDiscountRate(Boolean isDiscountRate) {
			this.isDiscountRate = isDiscountRate;
		}
		public Boolean getIsFixPrice() {
			return this.isFixPrice;
		}
		public void setIsFixPrice(Boolean isFixPrice) {
			this.isFixPrice = isFixPrice;
		}

}

	/**
 * 商品池活动的梯度列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OpenPromotionRuleStair extends TaobaoObject {

	private static final long serialVersionUID = 2527848157519535839L;

	/**
		 * 满x元【单位为分】
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 指定件数优惠规则
		 */
		@ApiField("cap_count_discount_rule")
		private CapCountDiscountRule capCountDiscountRule;
		/**
		 * 满x件
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 第N件优惠规则
		 */
		@ApiField("count_at_discount_rule")
		private CountAtDiscountRule countAtDiscountRule;
		/**
		 * 阶梯整体优惠规则
		 */
		@ApiField("cover_all_discount_rule")
		private CoverAllDiscountRule coverAllDiscountRule;
		/**
		 * 是否满元
		 */
		@ApiField("is_amount")
		private Boolean isAmount;
		/**
		 * 是否满件
		 */
		@ApiField("is_count")
		private Boolean isCount;
		/**
		 * 是否叠加逻辑分组的条件
		 */
		@ApiField("is_overlay_logic_group_condition")
		private Boolean isOverlayLogicGroupCondition;
		/**
		 * 分组表达式【暂时不使用】
		 */
		@ApiField("login_group_express")
		private String loginGroupExpress;
		/**
		 * 阶梯序号，代表商家的阶梯ID，同时代表阶梯优先级的顺序
		 */
		@ApiField("number")
		private Long number;
		/**
		 * 单独定价优惠规则
		 */
		@ApiField("separate_pricing_discount_rule")
		private SeparatePricingDiscountRule separatePricingDiscountRule;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public CapCountDiscountRule getCapCountDiscountRule() {
			return this.capCountDiscountRule;
		}
		public void setCapCountDiscountRule(CapCountDiscountRule capCountDiscountRule) {
			this.capCountDiscountRule = capCountDiscountRule;
		}
		public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public CountAtDiscountRule getCountAtDiscountRule() {
			return this.countAtDiscountRule;
		}
		public void setCountAtDiscountRule(CountAtDiscountRule countAtDiscountRule) {
			this.countAtDiscountRule = countAtDiscountRule;
		}
		public CoverAllDiscountRule getCoverAllDiscountRule() {
			return this.coverAllDiscountRule;
		}
		public void setCoverAllDiscountRule(CoverAllDiscountRule coverAllDiscountRule) {
			this.coverAllDiscountRule = coverAllDiscountRule;
		}
		public Boolean getIsAmount() {
			return this.isAmount;
		}
		public void setIsAmount(Boolean isAmount) {
			this.isAmount = isAmount;
		}
		public Boolean getIsCount() {
			return this.isCount;
		}
		public void setIsCount(Boolean isCount) {
			this.isCount = isCount;
		}
		public Boolean getIsOverlayLogicGroupCondition() {
			return this.isOverlayLogicGroupCondition;
		}
		public void setIsOverlayLogicGroupCondition(Boolean isOverlayLogicGroupCondition) {
			this.isOverlayLogicGroupCondition = isOverlayLogicGroupCondition;
		}
		public String getLoginGroupExpress() {
			return this.loginGroupExpress;
		}
		public void setLoginGroupExpress(String loginGroupExpress) {
			this.loginGroupExpress = loginGroupExpress;
		}
		public Long getNumber() {
			return this.number;
		}
		public void setNumber(Long number) {
			this.number = number;
		}
		public SeparatePricingDiscountRule getSeparatePricingDiscountRule() {
			return this.separatePricingDiscountRule;
		}
		public void setSeparatePricingDiscountRule(SeparatePricingDiscountRule separatePricingDiscountRule) {
			this.separatePricingDiscountRule = separatePricingDiscountRule;
		}

}

	/**
 * 活动优惠规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityRule extends TaobaoObject {

	private static final long serialVersionUID = 5283486777972357352L;

	/**
		 * 封顶金额
		 */
		@ApiField("ceiling_amount")
		private Long ceilingAmount;
		/**
		 * 1-可贬值，0-不可贬值
		 */
		@ApiField("discount_fee_mode")
		private Long discountFeeMode;
		/**
		 * 是否上不封顶
		 */
		@ApiField("enable_multiple")
		private Boolean enableMultiple;
		/**
		 * 是否单商品计数【NY使用】【废弃】
		 */
		@ApiField("is_alone")
		private Boolean isAlone;
		/**
		 * 是否叠加计算逻辑分组与阶梯满元【件】条件
		 */
		@ApiField("is_check_all_cond")
		private Boolean isCheckAllCond;
		/**
		 * 多阶梯是否可叠加
		 */
		@ApiField("is_multi_mix")
		private Boolean isMultiMix;
		/**
		 * 单商品是否累计
		 */
		@ApiField("item_overlay")
		private Boolean itemOverlay;
	

	public Long getCeilingAmount() {
			return this.ceilingAmount;
		}
		public void setCeilingAmount(Long ceilingAmount) {
			this.ceilingAmount = ceilingAmount;
		}
		public Long getDiscountFeeMode() {
			return this.discountFeeMode;
		}
		public void setDiscountFeeMode(Long discountFeeMode) {
			this.discountFeeMode = discountFeeMode;
		}
		public Boolean getEnableMultiple() {
			return this.enableMultiple;
		}
		public void setEnableMultiple(Boolean enableMultiple) {
			this.enableMultiple = enableMultiple;
		}
		public Boolean getIsAlone() {
			return this.isAlone;
		}
		public void setIsAlone(Boolean isAlone) {
			this.isAlone = isAlone;
		}
		public Boolean getIsCheckAllCond() {
			return this.isCheckAllCond;
		}
		public void setIsCheckAllCond(Boolean isCheckAllCond) {
			this.isCheckAllCond = isCheckAllCond;
		}
		public Boolean getIsMultiMix() {
			return this.isMultiMix;
		}
		public void setIsMultiMix(Boolean isMultiMix) {
			this.isMultiMix = isMultiMix;
		}
		public Boolean getItemOverlay() {
			return this.itemOverlay;
		}
		public void setItemOverlay(Boolean itemOverlay) {
			this.itemOverlay = itemOverlay;
		}

}

	/**
 * 逻辑分组规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OpenLogicGroupRule extends TaobaoObject {

	private static final long serialVersionUID = 7495571637722777863L;

	/**
		 * 逻辑分组上满N元条件，当阶梯的is_amount=true时生效，逻辑分组条件的优先级大于阶梯条件的优先级
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 换购N件
		 */
		@ApiField("can_extra_item_num")
		private Long canExtraItemNum;
		/**
		 * 逻辑分组上满N件条件，当阶梯的is_count=true时生效，逻辑分组条件的优先级大于阶梯条件的优先级
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 整体优惠
		 */
		@ApiField("cover_all_discount_rule")
		private CoverAllDiscountRule coverAllDiscountRule;
		/**
		 * 换购分组名称
		 */
		@ApiField("exchange_group_name")
		private String exchangeGroupName;
		/**
		 * 换购分组排序，用于在app上展示的顺序
		 */
		@ApiField("exchange_group_order")
		private Long exchangeGroupOrder;
		/**
		 * 是否为优惠作用分组
		 */
		@ApiField("is_effective_group")
		private Boolean isEffectiveGroup;
		/**
		 * 1-普通分组，2-换购分组，3-买赠分组
		 */
		@ApiField("logic_group_type")
		private Long logicGroupType;
		/**
		 * 商家逻辑分组Id（单个活动不能重复）
		 */
		@ApiField("number")
		private Long number;
		/**
		 * 分摊比例
		 */
		@ApiField("ratio")
		private Long ratio;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public Long getCanExtraItemNum() {
			return this.canExtraItemNum;
		}
		public void setCanExtraItemNum(Long canExtraItemNum) {
			this.canExtraItemNum = canExtraItemNum;
		}
		public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public CoverAllDiscountRule getCoverAllDiscountRule() {
			return this.coverAllDiscountRule;
		}
		public void setCoverAllDiscountRule(CoverAllDiscountRule coverAllDiscountRule) {
			this.coverAllDiscountRule = coverAllDiscountRule;
		}
		public String getExchangeGroupName() {
			return this.exchangeGroupName;
		}
		public void setExchangeGroupName(String exchangeGroupName) {
			this.exchangeGroupName = exchangeGroupName;
		}
		public Long getExchangeGroupOrder() {
			return this.exchangeGroupOrder;
		}
		public void setExchangeGroupOrder(Long exchangeGroupOrder) {
			this.exchangeGroupOrder = exchangeGroupOrder;
		}
		public Boolean getIsEffectiveGroup() {
			return this.isEffectiveGroup;
		}
		public void setIsEffectiveGroup(Boolean isEffectiveGroup) {
			this.isEffectiveGroup = isEffectiveGroup;
		}
		public Long getLogicGroupType() {
			return this.logicGroupType;
		}
		public void setLogicGroupType(Long logicGroupType) {
			this.logicGroupType = logicGroupType;
		}
		public Long getNumber() {
			return this.number;
		}
		public void setNumber(Long number) {
			this.number = number;
		}
		public Long getRatio() {
			return this.ratio;
		}
		public void setRatio(Long ratio) {
			this.ratio = ratio;
		}

}

	/**
 * 周期优惠信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PeriodConfig extends TaobaoObject {

	private static final long serialVersionUID = 3741868692561336584L;

	/**
		 * 每天的什么时间阶段搞活动,精确到秒单位 例如:03:00:00_05:00:00
		 */
		@ApiListField("every_day_periods")
		@ApiField("string")
		private List<String> everyDayPeriods;
		/**
		 * 星期几搞活动 [1:Mon;2:Tues;3:Wed;4:Thur;5:Fri;6:Sat;7:Sun]
		 */
		@ApiListField("weekdays")
		@ApiField("number")
		private List<Long> weekdays;
	

	public List<String> getEveryDayPeriods() {
			return this.everyDayPeriods;
		}
		public void setEveryDayPeriods(List<String> everyDayPeriods) {
			this.everyDayPeriods = everyDayPeriods;
		}
		public List<Long> getWeekdays() {
			return this.weekdays;
		}
		public void setWeekdays(List<Long> weekdays) {
			this.weekdays = weekdays;
		}

}

	/**
 * 自定义同步渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 4298392726667183652L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 创建活动请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolActivity extends TaobaoObject {

	private static final long serialVersionUID = 4213638631663661375L;

	/**
		 * 活动标题
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 活动优惠规则
		 */
		@ApiField("activity_rule")
		private ActivityRule activityRule;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 活动描述
		 */
		@ApiField("description")
		private String description;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 商品池是否排除特价
		 */
		@ApiField("exclude_single")
		private Boolean excludeSingle;
		/**
		 * 是否是类目优惠
		 */
		@ApiField("is_category")
		private Boolean isCategory;
		/**
		 * 是否是组合优惠
		 */
		@ApiField("is_comb")
		private Boolean isComb;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 逻辑分组规则
		 */
		@ApiListField("logic_group_rules")
		@ApiField("open_logic_group_rule")
		private List<OpenLogicGroupRule> logicGroupRules;
		/**
		 * 会员维度活动参与人群限制：-1:不限制 1:会员专享 2:非会员专享
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 周期优惠信息
		 */
		@ApiField("period_config")
		private PeriodConfig periodConfig;
		/**
		 * 活动优先级，值越大表示优先级越高，必须大于0
		 */
		@ApiField("priority_value")
		private Long priorityValue;
		/**
		 * 商品池活动的梯度列表
		 */
		@ApiListField("rule_stairs")
		@ApiField("open_promotion_rule_stair")
		private List<OpenPromotionRuleStair> ruleStairs;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 活动开始时间
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public ActivityRule getActivityRule() {
			return this.activityRule;
		}
		public void setActivityRule(ActivityRule activityRule) {
			this.activityRule = activityRule;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public Boolean getExcludeSingle() {
			return this.excludeSingle;
		}
		public void setExcludeSingle(Boolean excludeSingle) {
			this.excludeSingle = excludeSingle;
		}
		public Boolean getIsCategory() {
			return this.isCategory;
		}
		public void setIsCategory(Boolean isCategory) {
			this.isCategory = isCategory;
		}
		public Boolean getIsComb() {
			return this.isComb;
		}
		public void setIsComb(Boolean isComb) {
			this.isComb = isComb;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public List<OpenLogicGroupRule> getLogicGroupRules() {
			return this.logicGroupRules;
		}
		public void setLogicGroupRules(List<OpenLogicGroupRule> logicGroupRules) {
			this.logicGroupRules = logicGroupRules;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public PeriodConfig getPeriodConfig() {
			return this.periodConfig;
		}
		public void setPeriodConfig(PeriodConfig periodConfig) {
			this.periodConfig = periodConfig;
		}
		public Long getPriorityValue() {
			return this.priorityValue;
		}
		public void setPriorityValue(Long priorityValue) {
			this.priorityValue = priorityValue;
		}
		public List<OpenPromotionRuleStair> getRuleStairs() {
			return this.ruleStairs;
		}
		public void setRuleStairs(List<OpenPromotionRuleStair> ruleStairs) {
			this.ruleStairs = ruleStairs;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}


}