package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItempoolCreateactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.createactivity request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingItempoolCreateactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItempoolCreateactivityResponse> {
	
	

	/** 
	* 创建活动请求入参
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(ItemPoolActivity param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itempool.createactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItempoolCreateactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingItempoolCreateactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 通用限购信息，-1为不限制，默认为不限制
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LimitInfo extends TaobaoObject {

	private static final long serialVersionUID = 3346552664877925776L;

	/**
		 * 活动每日总限购
		 */
		@ApiField("daily_limit_cnt")
		private Long dailyLimitCnt;
		/**
		 * 活动期间总限购
		 */
		@ApiField("total_limit_cnt")
		private Long totalLimitCnt;
		/**
		 * 每人每日限购
		 */
		@ApiField("user_daily_limit_cnt")
		private Long userDailyLimitCnt;
		/**
		 * 每人活动期间总限购
		 */
		@ApiField("user_limit_cnt")
		private Long userLimitCnt;
	

	public Long getDailyLimitCnt() {
			return this.dailyLimitCnt;
		}
		public void setDailyLimitCnt(Long dailyLimitCnt) {
			this.dailyLimitCnt = dailyLimitCnt;
		}
		public Long getTotalLimitCnt() {
			return this.totalLimitCnt;
		}
		public void setTotalLimitCnt(Long totalLimitCnt) {
			this.totalLimitCnt = totalLimitCnt;
		}
		public Long getUserDailyLimitCnt() {
			return this.userDailyLimitCnt;
		}
		public void setUserDailyLimitCnt(Long userDailyLimitCnt) {
			this.userDailyLimitCnt = userDailyLimitCnt;
		}
		public Long getUserLimitCnt() {
			return this.userLimitCnt;
		}
		public void setUserLimitCnt(Long userLimitCnt) {
			this.userLimitCnt = userLimitCnt;
		}

}

	/**
 * 商品池活动的梯度列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Rulestairs extends TaobaoObject {

	private static final long serialVersionUID = 7824659384588295533L;

	/**
		 * 满多少元[单位为分，传入700，代表满7元]，amountAt为true时，必须设置
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 是否使用满元条件，不能与满件、N件Y折同时使用。此选项为true时，countAt和countBegin必须为false
		 */
		@ApiField("amount_at")
		private Boolean amountAt;
		/**
		 * 可换购的数量
		 */
		@ApiField("can_extra_item_num")
		private Long canExtraItemNum;
		/**
		 * 满多少件或者第多少件开始参与活动[传入4，代表满4件打折或者第4件打折]。该值与countBegin和countAt相关，如果countBegin为true，则为N件Y折活动，如果countAt为true，则为满件活动
		 */
		@ApiField("count")
		private Long count;
		/**
		 * 是否使用满件条件，不能与满元、N件Y折同时使用。此选项为true时，countBegin和amountAt必须为false
		 */
		@ApiField("count_at")
		private Boolean countAt;
		/**
		 * 是否使用N件Y折或N件Y元，不能与满元、满件同时使用。此选项为true时，countAt和amountAt必须为false
		 */
		@ApiField("count_begin")
		private Boolean countBegin;
		/**
		 * 是否使用减钱功能，不能与打折功能同时使用，此选项为true时，discount必须为false
		 */
		@ApiField("decrease")
		private Boolean decrease;
		/**
		 * 减多少元[单位为分，传入700，代表减7元]，decrease为true时，必须设置
		 */
		@ApiField("decrease_money")
		private Long decreaseMoney;
		/**
		 * 是否使用打折功能，不能与减钱功能同时使用，此选项为true时，decrease必须为false
		 */
		@ApiField("discount")
		private Boolean discount;
		/**
		 * 打几折[单位为分，传入900，代表打9折]，discount为true时，必须设置
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 活动是否上不封顶
		 */
		@ApiField("enable_multiple")
		private Boolean enableMultiple;
		/**
		 * 是否一口价
		 */
		@ApiField("fix_price")
		private Boolean fixPrice;
		/**
		 * 一口价[单位为分]
		 */
		@ApiField("fix_price_amount")
		private Long fixPriceAmount;
		/**
		 * 是否为换购活动
		 */
		@ApiField("is_exchange")
		private Boolean isExchange;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public Boolean getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Boolean amountAt) {
			this.amountAt = amountAt;
		}
		public Long getCanExtraItemNum() {
			return this.canExtraItemNum;
		}
		public void setCanExtraItemNum(Long canExtraItemNum) {
			this.canExtraItemNum = canExtraItemNum;
		}
		public Long getCount() {
			return this.count;
		}
		public void setCount(Long count) {
			this.count = count;
		}
		public Boolean getCountAt() {
			return this.countAt;
		}
		public void setCountAt(Boolean countAt) {
			this.countAt = countAt;
		}
		public Boolean getCountBegin() {
			return this.countBegin;
		}
		public void setCountBegin(Boolean countBegin) {
			this.countBegin = countBegin;
		}
		public Boolean getDecrease() {
			return this.decrease;
		}
		public void setDecrease(Boolean decrease) {
			this.decrease = decrease;
		}
		public Long getDecreaseMoney() {
			return this.decreaseMoney;
		}
		public void setDecreaseMoney(Long decreaseMoney) {
			this.decreaseMoney = decreaseMoney;
		}
		public Boolean getDiscount() {
			return this.discount;
		}
		public void setDiscount(Boolean discount) {
			this.discount = discount;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Boolean getEnableMultiple() {
			return this.enableMultiple;
		}
		public void setEnableMultiple(Boolean enableMultiple) {
			this.enableMultiple = enableMultiple;
		}
		public Boolean getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Boolean fixPrice) {
			this.fixPrice = fixPrice;
		}
		public Long getFixPriceAmount() {
			return this.fixPriceAmount;
		}
		public void setFixPriceAmount(Long fixPriceAmount) {
			this.fixPriceAmount = fixPriceAmount;
		}
		public Boolean getIsExchange() {
			return this.isExchange;
		}
		public void setIsExchange(Boolean isExchange) {
			this.isExchange = isExchange;
		}

}

	/**
 * 自定义同步渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 4162152932752541282L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 创建活动请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolActivity extends TaobaoObject {

	private static final long serialVersionUID = 7541139319128768734L;

	/**
		 * 商品池活动名称,不超过10个英文字符
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 商品池活动详情描述,不超过30个英文字符
		 */
		@ApiField("description")
		private String description;
		/**
		 * 活动结束时间，时间戳
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 是否是类目活动
		 */
		@ApiField("is_category")
		private Boolean isCategory;
		/**
		 * 通用限购信息，-1为不限制，默认为不限制
		 */
		@ApiField("limit_info")
		private LimitInfo limitInfo;
		/**
		 * 会员维度活动参与人群限制：-1:不限制 1:会员专享 2:非会员专享
		 */
		@ApiField("member_limit")
		private Long memberLimit;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
		/**
		 * 商品池活动的梯度列表
		 */
		@ApiListField("rule_stairs")
		@ApiField("rulestairs")
		private List<Rulestairs> ruleStairs;
		/**
		 * 参加活动的渠道店ids
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
		/**
		 * 活动开始时间，时间戳
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 优惠适用场景[APP|POS|POS+APP分别对应的值为1|2|1,2]
		 */
		@ApiListField("terminals")
		@ApiField("number")
		private List<Long> terminals;
		/**
		 * 淘鲜达人群编码
		 */
		@ApiField("txd_crowd_code")
		private String txdCrowdCode;
	

	public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public Boolean getIsCategory() {
			return this.isCategory;
		}
		public void setIsCategory(Boolean isCategory) {
			this.isCategory = isCategory;
		}
		public LimitInfo getLimitInfo() {
			return this.limitInfo;
		}
		public void setLimitInfo(LimitInfo limitInfo) {
			this.limitInfo = limitInfo;
		}
		public Long getMemberLimit() {
			return this.memberLimit;
		}
		public void setMemberLimit(Long memberLimit) {
			this.memberLimit = memberLimit;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}
		public List<Rulestairs> getRuleStairs() {
			return this.ruleStairs;
		}
		public void setRuleStairs(List<Rulestairs> ruleStairs) {
			this.ruleStairs = ruleStairs;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public List<Long> getTerminals() {
			return this.terminals;
		}
		public void setTerminals(List<Long> terminals) {
			this.terminals = terminals;
		}
		public String getTxdCrowdCode() {
			return this.txdCrowdCode;
		}
		public void setTxdCrowdCode(String txdCrowdCode) {
			this.txdCrowdCode = txdCrowdCode;
		}

}


}