package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItempoolItemAddAsyncResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.item.add.async request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingItempoolItemAddAsyncRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItempoolItemAddAsyncResponse> {
	
	

	/** 
	* 阶梯商品信息
	 */
	private String param0;

	/** 
	* 系统自动生成
	 */
	private String param1;

	/** 
	* alibaba.wdk.marketing.version.generate接口生成
	 */
	private Long version;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(List<ItemPoolSku> param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public void setVersion(Long version) {
		this.version = version;
	}

	public Long getVersion() {
		return this.version;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itempool.item.add.async";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		txtParams.put("version", this.version);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItempoolItemAddAsyncResponse> getResponseClass() {
		return AlibabaWdkMarketingItempoolItemAddAsyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(param0, 20, "param0");
		RequestCheckUtils.checkNotEmpty(version, "version");
	}
	
	/**
 * 阶梯商品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolSku extends TaobaoObject {

	private static final long serialVersionUID = 2783631477413632767L;

	/**
		 * 减钱【分】
		 */
		@ApiField("decrease_money")
		private Long decreaseMoney;
		/**
		 * 打折【如700,表示打7折】
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 一口价【分】
		 */
		@ApiField("fix_price")
		private Long fixPrice;
		/**
		 * 是否减钱
		 */
		@ApiField("is_decrease_money")
		private Boolean isDecreaseMoney;
		/**
		 * 是否打折
		 */
		@ApiField("is_discount_rate")
		private Boolean isDiscountRate;
		/**
		 * 是否一口价
		 */
		@ApiField("is_fix_price")
		private Boolean isFixPrice;
		/**
		 * 商家阶梯下分组序号
		 */
		@ApiField("logic_group_number")
		private Long logicGroupNumber;
		/**
		 * 商品编码
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getDecreaseMoney() {
			return this.decreaseMoney;
		}
		public void setDecreaseMoney(Long decreaseMoney) {
			this.decreaseMoney = decreaseMoney;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Long getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Long fixPrice) {
			this.fixPrice = fixPrice;
		}
		public Boolean getIsDecreaseMoney() {
			return this.isDecreaseMoney;
		}
		public void setIsDecreaseMoney(Boolean isDecreaseMoney) {
			this.isDecreaseMoney = isDecreaseMoney;
		}
		public Boolean getIsDiscountRate() {
			return this.isDiscountRate;
		}
		public void setIsDiscountRate(Boolean isDiscountRate) {
			this.isDiscountRate = isDiscountRate;
		}
		public Boolean getIsFixPrice() {
			return this.isFixPrice;
		}
		public void setIsFixPrice(Boolean isFixPrice) {
			this.isFixPrice = isFixPrice;
		}
		public Long getLogicGroupNumber() {
			return this.logicGroupNumber;
		}
		public void setLogicGroupNumber(Long logicGroupNumber) {
			this.logicGroupNumber = logicGroupNumber;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 2444439194959688326L;

	/**
		 * 活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 外部活动编码
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}