package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItempoolQueryactivityResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.queryactivity request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingItempoolQueryactivityRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItempoolQueryactivityResponse> {
	
	

	/** 
	* 查询商品池活动入参
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(CommonActivityParam param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itempool.queryactivity";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItempoolQueryactivityResponse> getResponseClass() {
		return AlibabaWdkMarketingItempoolQueryactivityResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 自定义同步渠道配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ChannelConfig extends TaobaoObject {

	private static final long serialVersionUID = 1393637177211117949L;

	/**
		 * 淘鲜达:"31",饿了么:"3",京东到家:"26",美团外卖:"2"
		 */
		@ApiField("channel")
		private String channel;
	

	public String getChannel() {
			return this.channel;
		}
		public void setChannel(String channel) {
			this.channel = channel;
		}

}

	/**
 * 查询商品池活动入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 8353952749548284727L;

	/**
		 * 五道口活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 是否自定义渠道同步
		 */
		@ApiField("by_channel")
		private Boolean byChannel;
		/**
		 * 自定义同步渠道配置
		 */
		@ApiListField("channel_config_list")
		@ApiField("channel_config")
		private List<ChannelConfig> channelConfigList;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public Boolean getByChannel() {
			return this.byChannel;
		}
		public void setByChannel(Boolean byChannel) {
			this.byChannel = byChannel;
		}
		public List<ChannelConfig> getChannelConfigList() {
			return this.channelConfigList;
		}
		public void setChannelConfigList(List<ChannelConfig> channelConfigList) {
			this.channelConfigList = channelConfigList;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}