package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingItempoolStairAdditemResponse;

/**
 * TOP API: alibaba.wdk.marketing.itempool.stair.additem request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingItempoolStairAdditemRequest extends BaseTaobaoRequest<AlibabaWdkMarketingItempoolStairAdditemResponse> {
	
	

	/** 
	* 系统自动生成
	 */
	private String param0;

	/** 
	* 系统自动生成
	 */
	private String param1;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(ItemPoolSku param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public void setParam1(String param1) {
		this.param1 = param1;
	}

	public void setParam1(CommonActivityParam param1) {
		this.param1 = new JSONWriter(false,true).write(param1);
	}

	public String getParam1() {
		return this.param1;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.itempool.stair.additem";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		txtParams.put("param1", this.param1);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingItempoolStairAdditemResponse> getResponseClass() {
		return AlibabaWdkMarketingItempoolStairAdditemResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPoolSku extends TaobaoObject {

	private static final long serialVersionUID = 2655949858788452929L;

	/**
		 * 单位为分
		 */
		@ApiField("exchange_price")
		private Long exchangePrice;
		/**
		 * 换购商品总数限制
		 */
		@ApiField("exchange_total_limit")
		private Long exchangeTotalLimit;
		/**
		 * 商品skucode
		 */
		@ApiField("sku_code")
		private String skuCode;
	

	public Long getExchangePrice() {
			return this.exchangePrice;
		}
		public void setExchangePrice(Long exchangePrice) {
			this.exchangePrice = exchangePrice;
		}
		public Long getExchangeTotalLimit() {
			return this.exchangeTotalLimit;
		}
		public void setExchangeTotalLimit(Long exchangeTotalLimit) {
			this.exchangeTotalLimit = exchangeTotalLimit;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CommonActivityParam extends TaobaoObject {

	private static final long serialVersionUID = 6887516787824994213L;

	/**
		 * 报名活动Id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 商家活动id
		 */
		@ApiField("out_act_id")
		private String outActId;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getOutActId() {
			return this.outActId;
		}
		public void setOutActId(String outActId) {
			this.outActId = outActId;
		}

}


}