package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingOpenDarunfaActivitySkuSyncResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.darunfa.activity.sku.sync request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.13
 */
public class AlibabaWdkMarketingOpenDarunfaActivitySkuSyncRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenDarunfaActivitySkuSyncResponse> {
	
	

	/** 
	* 大润发活动Id
	 */
	private String activityId;

	/** 
	* 淘鲜达活动商品信息
	 */
	private String activitySkuList;

	/** 
	* 活动对应的门店Id
	 */
	private String shopId;

	/** 
	* 数据版本Id
	 */
	private Long versionId;

	public void setActivityId(String activityId) {
		this.activityId = activityId;
	}

	public String getActivityId() {
		return this.activityId;
	}

	public void setActivitySkuList(String activitySkuList) {
		this.activitySkuList = activitySkuList;
	}

	public void setActivitySkuList(List<DrfTxdActivitySkuBo> activitySkuList) {
		this.activitySkuList = new JSONWriter(false,true).write(activitySkuList);
	}

	public String getActivitySkuList() {
		return this.activitySkuList;
	}

	public void setShopId(String shopId) {
		this.shopId = shopId;
	}

	public String getShopId() {
		return this.shopId;
	}

	public void setVersionId(Long versionId) {
		this.versionId = versionId;
	}

	public Long getVersionId() {
		return this.versionId;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.darunfa.activity.sku.sync";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		txtParams.put("activity_sku_list", this.activitySkuList);
		txtParams.put("shop_id", this.shopId);
		txtParams.put("version_id", this.versionId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenDarunfaActivitySkuSyncResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenDarunfaActivitySkuSyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
		RequestCheckUtils.checkObjectMaxListSize(activitySkuList, 200, "activitySkuList");
		RequestCheckUtils.checkNotEmpty(versionId, "versionId");
	}
	
	/**
 * 淘鲜达活动商品信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrfTxdActivitySkuBo extends TaobaoObject {

	private static final long serialVersionUID = 5798586711458965373L;

	/**
		 * 大润发活动类型
		 */
		@ApiField("activity_type")
		private Long activityType;
		/**
		 * 商品对应的活动Id，仅当同一次任务有相关活动更新的时候在传入
		 */
		@ApiField("activity_version_id")
		private Long activityVersionId;
		/**
		 * 买赠门槛
		 */
		@ApiField("buy_num")
		private Long buyNum;
		/**
		 * 门槛数量：件金额（分）
		 */
		@ApiField("condition_num")
		private Long conditionNum;
		/**
		 * 门槛类型：2-累计金额消费，3-累计购买次数消费
		 */
		@ApiField("condition_type")
		private Long conditionType;
		/**
		 * 减钱
		 */
		@ApiField("decrease_money")
		private Long decreaseMoney;
		/**
		 * 对应单品积分活动。对应需要扣除的积分数
		 */
		@ApiField("deduct_point")
		private Long deductPoint;
		/**
		 * 打折
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 一口价
		 */
		@ApiField("fix_price")
		private Long fixPrice;
		/**
		 * 赠品skuCode
		 */
		@ApiField("gift_sku_code")
		private String giftSkuCode;
		/**
		 * 插入时间
		 */
		@ApiField("insert_time")
		private Long insertTime;
		/**
		 * 限购权重
		 */
		@ApiField("limit_weight")
		private Long limitWeight;
		/**
		 * 商品池ID
		 */
		@ApiField("pool_id")
		private Long poolId;
		/**
		 * 所属活动ID
		 */
		@ApiField("promotion_id")
		private String promotionId;
		/**
		 * 商品编码
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 状态：0--不可用，1--可用
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 活动每日限购
		 */
		@ApiField("total_day_limit")
		private Long totalDayLimit;
		/**
		 * 总限购数量
		 */
		@ApiField("total_limit")
		private Long totalLimit;
		/**
		 * 淘鲜达活动Id
		 */
		@ApiField("txd_activity_id")
		private Long txdActivityId;
		/**
		 * 更新时间
		 */
		@ApiField("update_time")
		private Long updateTime;
		/**
		 * 用户每日限购
		 */
		@ApiField("user_day_limit")
		private Long userDayLimit;
		/**
		 * 用户限购
		 */
		@ApiField("user_limit")
		private Long userLimit;
	

	public Long getActivityType() {
			return this.activityType;
		}
		public void setActivityType(Long activityType) {
			this.activityType = activityType;
		}
		public Long getActivityVersionId() {
			return this.activityVersionId;
		}
		public void setActivityVersionId(Long activityVersionId) {
			this.activityVersionId = activityVersionId;
		}
		public Long getBuyNum() {
			return this.buyNum;
		}
		public void setBuyNum(Long buyNum) {
			this.buyNum = buyNum;
		}
		public Long getConditionNum() {
			return this.conditionNum;
		}
		public void setConditionNum(Long conditionNum) {
			this.conditionNum = conditionNum;
		}
		public Long getConditionType() {
			return this.conditionType;
		}
		public void setConditionType(Long conditionType) {
			this.conditionType = conditionType;
		}
		public Long getDecreaseMoney() {
			return this.decreaseMoney;
		}
		public void setDecreaseMoney(Long decreaseMoney) {
			this.decreaseMoney = decreaseMoney;
		}
		public Long getDeductPoint() {
			return this.deductPoint;
		}
		public void setDeductPoint(Long deductPoint) {
			this.deductPoint = deductPoint;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Long getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Long fixPrice) {
			this.fixPrice = fixPrice;
		}
		public String getGiftSkuCode() {
			return this.giftSkuCode;
		}
		public void setGiftSkuCode(String giftSkuCode) {
			this.giftSkuCode = giftSkuCode;
		}
		public Long getInsertTime() {
			return this.insertTime;
		}
		public void setInsertTime(Long insertTime) {
			this.insertTime = insertTime;
		}
		public Long getLimitWeight() {
			return this.limitWeight;
		}
		public void setLimitWeight(Long limitWeight) {
			this.limitWeight = limitWeight;
		}
		public Long getPoolId() {
			return this.poolId;
		}
		public void setPoolId(Long poolId) {
			this.poolId = poolId;
		}
		public String getPromotionId() {
			return this.promotionId;
		}
		public void setPromotionId(String promotionId) {
			this.promotionId = promotionId;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getTotalDayLimit() {
			return this.totalDayLimit;
		}
		public void setTotalDayLimit(Long totalDayLimit) {
			this.totalDayLimit = totalDayLimit;
		}
		public Long getTotalLimit() {
			return this.totalLimit;
		}
		public void setTotalLimit(Long totalLimit) {
			this.totalLimit = totalLimit;
		}
		public Long getTxdActivityId() {
			return this.txdActivityId;
		}
		public void setTxdActivityId(Long txdActivityId) {
			this.txdActivityId = txdActivityId;
		}
		public Long getUpdateTime() {
			return this.updateTime;
		}
		public void setUpdateTime(Long updateTime) {
			this.updateTime = updateTime;
		}
		public Long getUserDayLimit() {
			return this.userDayLimit;
		}
		public void setUserDayLimit(Long userDayLimit) {
			this.userDayLimit = userDayLimit;
		}
		public Long getUserLimit() {
			return this.userLimit;
		}
		public void setUserLimit(Long userLimit) {
			this.userLimit = userLimit;
		}

}


}