package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingOpenDarunfaActivitySyncResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.darunfa.activity.sync request
 * 
 * @author top auto create
 * @since 1.0, 2022.03.07
 */
public class AlibabaWdkMarketingOpenDarunfaActivitySyncRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenDarunfaActivitySyncResponse> {
	
	

	/** 
	* 大润发活动数据
	 */
	private String activityList;

	/** 
	* 门店Id
	 */
	private String shopId;

	/** 
	* 版本ID
	 */
	private Long versionId;

	public void setActivityList(String activityList) {
		this.activityList = activityList;
	}

	public void setActivityList(List<DrfTxdActivityBo> activityList) {
		this.activityList = new JSONWriter(false,true).write(activityList);
	}

	public String getActivityList() {
		return this.activityList;
	}

	public void setShopId(String shopId) {
		this.shopId = shopId;
	}

	public String getShopId() {
		return this.shopId;
	}

	public void setVersionId(Long versionId) {
		this.versionId = versionId;
	}

	public Long getVersionId() {
		return this.versionId;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.darunfa.activity.sync";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_list", this.activityList);
		txtParams.put("shop_id", this.shopId);
		txtParams.put("version_id", this.versionId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenDarunfaActivitySyncResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenDarunfaActivitySyncResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(activityList, 200, "activityList");
		RequestCheckUtils.checkNotEmpty(shopId, "shopId");
		RequestCheckUtils.checkNotEmpty(versionId, "versionId");
	}
	
	/**
 * 大润发活动数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DrfTxdActivityBo extends TaobaoObject {

	private static final long serialVersionUID = 5655536175845995785L;

	/**
		 * 换购机台
		 */
		@ApiField("activity_channel")
		private String activityChannel;
		/**
		 * 活动描述
		 */
		@ApiField("activity_content")
		private String activityContent;
		/**
		 * 活动名称
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * ?营销中台活动类型
		 */
		@ApiField("activity_type")
		private Long activityType;
		/**
		 * 封顶金额，单位：分
		 */
		@ApiField("celling_amount")
		private Long cellingAmount;
		/**
		 * 第N件活动规则
		 */
		@ApiField("count_at")
		private Long countAt;
		/**
		 * 是否可贬值；0--否，1--是
		 */
		@ApiField("discount_fee_model")
		private Long discountFeeModel;
		/**
		 * 单品特价类型；1-一口价；2-打折；3-减钱
		 */
		@ApiField("discount_type")
		private Long discountType;
		/**
		 * 是否上不封顶；0--否，1--是
		 */
		@ApiField("enable_multiple")
		private Long enableMultiple;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_date")
		private Long endDate;
		/**
		 * 一口价【分】
		 */
		@ApiField("fix_price")
		private Long fixPrice;
		/**
		 * 插入时间
		 */
		@ApiField("insert_time")
		private Long insertTime;
		/**
		 * 是否针对单个商品使用优惠
		 */
		@ApiField("is_alone")
		private Long isAlone;
		/**
		 * 是否叠加逻辑分组与阶梯条件；0-否，1-是
		 */
		@ApiField("is_check_all_cond")
		private Long isCheckAllCond;
		/**
		 * 是否多阶梯可叠加，0--否，1--是
		 */
		@ApiField("is_multi_mix")
		private Long isMultiMix;
		/**
		 * 是否单商品累计，0--否，1--是
		 */
		@ApiField("item_overlay")
		private Long itemOverlay;
		/**
		 * 限购权重，实际限购=限购值限购权重
		 */
		@ApiField("limit_weight")
		private Long limitWeight;
		/**
		 * 商家人群编码
		 */
		@ApiField("merchant_crowd_code")
		private String merchantCrowdCode;
		/**
		 * 周期生效配置，weekdays：星期几搞活动 [1:Mon;2:Tues;3:Wed;4:Thur;5:Fri;6:Sat;7:Sun]；every_day_periods：每天的什么时间阶段搞活动,精确到秒单位,最多支持5段 例如:03:00:00_05:00:00，示例：{"weekdays":[1,2,3,4,5,6,7],"every_day_periods":["03:00:00_05:00:00","18:00:00_21:00:00"]}
		 */
		@ApiField("period_config")
		private String periodConfig;
		/**
		 * 商品池数量
		 */
		@ApiField("pool_num")
		private Long poolNum;
		/**
		 * 商品池规则
		 */
		@ApiField("pool_rules")
		private String poolRules;
		/**
		 * 中台活动Id（全局唯一）
		 */
		@ApiField("promotion_id")
		private String promotionId;
		/**
		 * 商品池阶梯规则
		 */
		@ApiField("stair_rules")
		private String stairRules;
		/**
		 * 活动开始时间
		 */
		@ApiField("start_date")
		private Long startDate;
		/**
		 * 0--不可用；1--可用
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 门店Id
		 */
		@ApiField("store_ids")
		private String storeIds;
		/**
		 * 1--pos,2--App;1,2--pos&App
		 */
		@ApiField("terminals")
		private String terminals;
		/**
		 * 活动每日限购
		 */
		@ApiField("total_day_limit")
		private Long totalDayLimit;
		/**
		 * 活动总限购
		 */
		@ApiField("total_limit")
		private Long totalLimit;
		/**
		 * 淘鲜达活动Id
		 */
		@ApiField("txd_activity_id")
		private Long txdActivityId;
		/**
		 * 更新时间
		 */
		@ApiField("update_time")
		private Long updateTime;
		/**
		 * 用户每日限购
		 */
		@ApiField("user_day_limit")
		private Long userDayLimit;
		/**
		 * 用户数量总限购
		 */
		@ApiField("user_limit")
		private Long userLimit;
	

	public String getActivityChannel() {
			return this.activityChannel;
		}
		public void setActivityChannel(String activityChannel) {
			this.activityChannel = activityChannel;
		}
		public String getActivityContent() {
			return this.activityContent;
		}
		public void setActivityContent(String activityContent) {
			this.activityContent = activityContent;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Long getActivityType() {
			return this.activityType;
		}
		public void setActivityType(Long activityType) {
			this.activityType = activityType;
		}
		public Long getCellingAmount() {
			return this.cellingAmount;
		}
		public void setCellingAmount(Long cellingAmount) {
			this.cellingAmount = cellingAmount;
		}
		public Long getCountAt() {
			return this.countAt;
		}
		public void setCountAt(Long countAt) {
			this.countAt = countAt;
		}
		public Long getDiscountFeeModel() {
			return this.discountFeeModel;
		}
		public void setDiscountFeeModel(Long discountFeeModel) {
			this.discountFeeModel = discountFeeModel;
		}
		public Long getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(Long discountType) {
			this.discountType = discountType;
		}
		public Long getEnableMultiple() {
			return this.enableMultiple;
		}
		public void setEnableMultiple(Long enableMultiple) {
			this.enableMultiple = enableMultiple;
		}
		public Long getEndDate() {
			return this.endDate;
		}
		public void setEndDate(Long endDate) {
			this.endDate = endDate;
		}
		public Long getFixPrice() {
			return this.fixPrice;
		}
		public void setFixPrice(Long fixPrice) {
			this.fixPrice = fixPrice;
		}
		public Long getInsertTime() {
			return this.insertTime;
		}
		public void setInsertTime(Long insertTime) {
			this.insertTime = insertTime;
		}
		public Long getIsAlone() {
			return this.isAlone;
		}
		public void setIsAlone(Long isAlone) {
			this.isAlone = isAlone;
		}
		public Long getIsCheckAllCond() {
			return this.isCheckAllCond;
		}
		public void setIsCheckAllCond(Long isCheckAllCond) {
			this.isCheckAllCond = isCheckAllCond;
		}
		public Long getIsMultiMix() {
			return this.isMultiMix;
		}
		public void setIsMultiMix(Long isMultiMix) {
			this.isMultiMix = isMultiMix;
		}
		public Long getItemOverlay() {
			return this.itemOverlay;
		}
		public void setItemOverlay(Long itemOverlay) {
			this.itemOverlay = itemOverlay;
		}
		public Long getLimitWeight() {
			return this.limitWeight;
		}
		public void setLimitWeight(Long limitWeight) {
			this.limitWeight = limitWeight;
		}
		public String getMerchantCrowdCode() {
			return this.merchantCrowdCode;
		}
		public void setMerchantCrowdCode(String merchantCrowdCode) {
			this.merchantCrowdCode = merchantCrowdCode;
		}
		public String getPeriodConfig() {
			return this.periodConfig;
		}
		public void setPeriodConfig(String periodConfig) {
			this.periodConfig = periodConfig;
		}
		public Long getPoolNum() {
			return this.poolNum;
		}
		public void setPoolNum(Long poolNum) {
			this.poolNum = poolNum;
		}
		public String getPoolRules() {
			return this.poolRules;
		}
		public void setPoolRules(String poolRules) {
			this.poolRules = poolRules;
		}
		public String getPromotionId() {
			return this.promotionId;
		}
		public void setPromotionId(String promotionId) {
			this.promotionId = promotionId;
		}
		public String getStairRules() {
			return this.stairRules;
		}
		public void setStairRules(String stairRules) {
			this.stairRules = stairRules;
		}
		public Long getStartDate() {
			return this.startDate;
		}
		public void setStartDate(Long startDate) {
			this.startDate = startDate;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getStoreIds() {
			return this.storeIds;
		}
		public void setStoreIds(String storeIds) {
			this.storeIds = storeIds;
		}
		public String getTerminals() {
			return this.terminals;
		}
		public void setTerminals(String terminals) {
			this.terminals = terminals;
		}
		public Long getTotalDayLimit() {
			return this.totalDayLimit;
		}
		public void setTotalDayLimit(Long totalDayLimit) {
			this.totalDayLimit = totalDayLimit;
		}
		public Long getTotalLimit() {
			return this.totalLimit;
		}
		public void setTotalLimit(Long totalLimit) {
			this.totalLimit = totalLimit;
		}
		public Long getTxdActivityId() {
			return this.txdActivityId;
		}
		public void setTxdActivityId(Long txdActivityId) {
			this.txdActivityId = txdActivityId;
		}
		public Long getUpdateTime() {
			return this.updateTime;
		}
		public void setUpdateTime(Long updateTime) {
			this.updateTime = updateTime;
		}
		public Long getUserDayLimit() {
			return this.userDayLimit;
		}
		public void setUserDayLimit(Long userDayLimit) {
			this.userDayLimit = userDayLimit;
		}
		public Long getUserLimit() {
			return this.userLimit;
		}
		public void setUserLimit(Long userLimit) {
			this.userLimit = userLimit;
		}

}


}