package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaWdkMarketingOpenDataRelationQueryResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.data.relation.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class AlibabaWdkMarketingOpenDataRelationQueryRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenDataRelationQueryResponse> {
	
	

	/** 
	* 数据类型：WDK_MARKET:五道口营销
	 */
	private String bizCode;

	/** 
	* 外部数据Id
	 */
	private String outDataIds;

	/** 
	* 数据子类型：ACTIVITY:营销活动数据
	 */
	private String subBizCode;

	public void setBizCode(String bizCode) {
		this.bizCode = bizCode;
	}

	public String getBizCode() {
		return this.bizCode;
	}

	public void setOutDataIds(String outDataIds) {
		this.outDataIds = outDataIds;
	}

	public String getOutDataIds() {
		return this.outDataIds;
	}

	public void setSubBizCode(String subBizCode) {
		this.subBizCode = subBizCode;
	}

	public String getSubBizCode() {
		return this.subBizCode;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.data.relation.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_code", this.bizCode);
		txtParams.put("out_data_ids", this.outDataIds);
		txtParams.put("sub_biz_code", this.subBizCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenDataRelationQueryResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenDataRelationQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizCode, "bizCode");
		RequestCheckUtils.checkNotEmpty(outDataIds, "outDataIds");
		RequestCheckUtils.checkMaxListSize(outDataIds, 200, "outDataIds");
		RequestCheckUtils.checkNotEmpty(subBizCode, "subBizCode");
	}
	

}