package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingOpenHeartbeatResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.heartbeat request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkMarketingOpenHeartbeatRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenHeartbeatResponse> {
	
	

	/** 
	* 心跳信息
	 */
	private String heartBeat;

	public void setHeartBeat(String heartBeat) {
		this.heartBeat = heartBeat;
	}

	public void setHeartBeat(HeartBeatBo heartBeat) {
		this.heartBeat = new JSONWriter(false,true).write(heartBeat);
	}

	public String getHeartBeat() {
		return this.heartBeat;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.heartbeat";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("heart_beat", this.heartBeat);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenHeartbeatResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenHeartbeatResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 心跳信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class HeartBeatBo extends TaobaoObject {

	private static final long serialVersionUID = 1568588487881471918L;

	/**
		 * MARKET-营销，ITEM-商品
		 */
		@ApiField("biz_code")
		private String bizCode;
		/**
		 * 当前版本信息
		 */
		@ApiField("version_id")
		private Long versionId;
	

	public String getBizCode() {
			return this.bizCode;
		}
		public void setBizCode(String bizCode) {
			this.bizCode = bizCode;
		}
		public Long getVersionId() {
			return this.versionId;
		}
		public void setVersionId(Long versionId) {
			this.versionId = versionId;
		}

}


}