package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingOpenPosDiscountCodeCreateResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.pos.discount.code.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.10.27
 */
public class AlibabaWdkMarketingOpenPosDiscountCodeCreateRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenPosDiscountCodeCreateResponse> {
	
	

	/** 
	* 请求信息
	 */
	private String uniqueDiscountCodeRequest;

	public void setUniqueDiscountCodeRequest(String uniqueDiscountCodeRequest) {
		this.uniqueDiscountCodeRequest = uniqueDiscountCodeRequest;
	}

	public void setUniqueDiscountCodeRequest(UniqueDiscountCodeRequest uniqueDiscountCodeRequest) {
		this.uniqueDiscountCodeRequest = new JSONWriter(false,true).write(uniqueDiscountCodeRequest);
	}

	public String getUniqueDiscountCodeRequest() {
		return this.uniqueDiscountCodeRequest;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.pos.discount.code.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("unique_discount_code_request", this.uniqueDiscountCodeRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenPosDiscountCodeCreateResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenPosDiscountCodeCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class UniqueDiscountCodeRequest extends TaobaoObject {

	private static final long serialVersionUID = 5763824384373865544L;

	/**
		 * 一口价。单位分。对应 discountType=8 时必传
		 */
		@ApiField("discount_price")
		private Long discountPrice;
		/**
		 * 折扣率 范围(0,100) 比如78折传78，8折传80。对应 discountType=7时必传
		 */
		@ApiField("discount_rate")
		private Long discountRate;
		/**
		 * 折扣码类型, 7为折扣率码，8为一口价码
		 */
		@ApiField("discount_type")
		private Long discountType;
		/**
		 * 过期时间。不传默认为当前时间+90天。最大支持有效期为90天后。
		 */
		@ApiField("expire_time")
		private String expireTime;
		/**
		 * 商品编码
		 */
		@ApiField("sku_code")
		private String skuCode;
		/**
		 * 门店编码
		 */
		@ApiField("store_id")
		private String storeId;
	

	public Long getDiscountPrice() {
			return this.discountPrice;
		}
		public void setDiscountPrice(Long discountPrice) {
			this.discountPrice = discountPrice;
		}
		public Long getDiscountRate() {
			return this.discountRate;
		}
		public void setDiscountRate(Long discountRate) {
			this.discountRate = discountRate;
		}
		public Long getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(Long discountType) {
			this.discountType = discountType;
		}
		public String getExpireTime() {
			return this.expireTime;
		}
		public void setExpireTime(String expireTime) {
			this.expireTime = expireTime;
		}
		public String getSkuCode() {
			return this.skuCode;
		}
		public void setSkuCode(String skuCode) {
			this.skuCode = skuCode;
		}
		public String getStoreId() {
			return this.storeId;
		}
		public void setStoreId(String storeId) {
			this.storeId = storeId;
		}

}


}