package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingOpenVersionApplyResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.version.apply request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class AlibabaWdkMarketingOpenVersionApplyRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenVersionApplyResponse> {
	
	

	/** 
	* 同步版本信息
	 */
	private String syncVersion;

	public void setSyncVersion(String syncVersion) {
		this.syncVersion = syncVersion;
	}

	public void setSyncVersion(SyncVersionBo syncVersion) {
		this.syncVersion = new JSONWriter(false,true).write(syncVersion);
	}

	public String getSyncVersion() {
		return this.syncVersion;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.version.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("sync_version", this.syncVersion);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenVersionApplyResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenVersionApplyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 同步版本信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SyncVersionBo extends TaobaoObject {

	private static final long serialVersionUID = 5349518334331515671L;

	/**
		 * WDK_MARKET--营销数据
		 */
		@ApiField("biz_code")
		private String bizCode;
		/**
		 * 操作ID
		 */
		@ApiField("operate_id")
		private String operateId;
		/**
		 * 外部唯一ID
		 */
		@ApiField("out_unique_id")
		private String outUniqueId;
		/**
		 * 数据周期结束时间
		 */
		@ApiField("range_end_time")
		private Long rangeEndTime;
		/**
		 * 数据周期开始时间
		 */
		@ApiField("range_start_time")
		private Long rangeStartTime;
		/**
		 * 同步的数据表名称
		 */
		@ApiField("table_name")
		private String tableName;
		/**
		 * 同步数据总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public String getBizCode() {
			return this.bizCode;
		}
		public void setBizCode(String bizCode) {
			this.bizCode = bizCode;
		}
		public String getOperateId() {
			return this.operateId;
		}
		public void setOperateId(String operateId) {
			this.operateId = operateId;
		}
		public String getOutUniqueId() {
			return this.outUniqueId;
		}
		public void setOutUniqueId(String outUniqueId) {
			this.outUniqueId = outUniqueId;
		}
		public Long getRangeEndTime() {
			return this.rangeEndTime;
		}
		public void setRangeEndTime(Long rangeEndTime) {
			this.rangeEndTime = rangeEndTime;
		}
		public Long getRangeStartTime() {
			return this.rangeStartTime;
		}
		public void setRangeStartTime(Long rangeStartTime) {
			this.rangeStartTime = rangeStartTime;
		}
		public String getTableName() {
			return this.tableName;
		}
		public void setTableName(String tableName) {
			this.tableName = tableName;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}


}