package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaWdkMarketingOpenVersionCountResponse;

/**
 * TOP API: alibaba.wdk.marketing.open.version.count request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class AlibabaWdkMarketingOpenVersionCountRequest extends BaseTaobaoRequest<AlibabaWdkMarketingOpenVersionCountResponse> {
	
	

	/** 
	* 操作Id
	 */
	private String operateId;

	/** 
	* 查询版本号
	 */
	private Long versionId;

	public void setOperateId(String operateId) {
		this.operateId = operateId;
	}

	public String getOperateId() {
		return this.operateId;
	}

	public void setVersionId(Long versionId) {
		this.versionId = versionId;
	}

	public Long getVersionId() {
		return this.versionId;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.open.version.count";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("operate_id", this.operateId);
		txtParams.put("version_id", this.versionId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingOpenVersionCountResponse> getResponseClass() {
		return AlibabaWdkMarketingOpenVersionCountResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(operateId, "operateId");
		RequestCheckUtils.checkNotEmpty(versionId, "versionId");
	}
	

}