package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaWdkMarketingPriceResponse;

/**
 * TOP API: alibaba.wdk.marketing.price request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.22
 */
public class AlibabaWdkMarketingPriceRequest extends BaseTaobaoRequest<AlibabaWdkMarketingPriceResponse> {
	
	

	/** 
	* 查询开始时间(sku_codes非空无效)
	 */
	private Date beginTime;

	/** 
	* 查询结束时间(sku_codes非空无效)
	 */
	private Date endTime;

	/** 
	* 页码
	 */
	private Long pageIndex;

	/** 
	* 单页大小
	 */
	private Long pageSize;

	/** 
	* 门店标识数组
	 */
	private String shopIds;

	/** 
	* 商品sku
	 */
	private String skuCodes;

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}

	public Date getBeginTime() {
		return this.beginTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setPageIndex(Long pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Long getPageIndex() {
		return this.pageIndex;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setShopIds(String shopIds) {
		this.shopIds = shopIds;
	}

	public String getShopIds() {
		return this.shopIds;
	}

	public void setSkuCodes(String skuCodes) {
		this.skuCodes = skuCodes;
	}

	public String getSkuCodes() {
		return this.skuCodes;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.price";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("begin_time", this.beginTime);
		txtParams.put("end_time", this.endTime);
		txtParams.put("page_index", this.pageIndex);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("shop_ids", this.shopIds);
		txtParams.put("sku_codes", this.skuCodes);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingPriceResponse> getResponseClass() {
		return AlibabaWdkMarketingPriceResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(pageIndex, "pageIndex");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkMaxListSize(shopIds, 20, "shopIds");
		RequestCheckUtils.checkMaxListSize(skuCodes, 20, "skuCodes");
	}
	

}