package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaWdkMarketingVersionGenerateResponse;

/**
 * TOP API: alibaba.wdk.marketing.version.generate request
 * 
 * @author top auto create
 * @since 1.0, 2023.07.19
 */
public class AlibabaWdkMarketingVersionGenerateRequest extends BaseTaobaoRequest<AlibabaWdkMarketingVersionGenerateResponse> {
	
	

	/** 
	* 档期版本号参数信息
	 */
	private String param;

	public void setParam(String param) {
		this.param = param;
	}

	public void setParam(SeasonVersionParam param) {
		this.param = new JSONWriter(false,true).write(param);
	}

	public String getParam() {
		return this.param;
	}

	public String getApiMethodName() {
		return "alibaba.wdk.marketing.version.generate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param", this.param);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaWdkMarketingVersionGenerateResponse> getResponseClass() {
		return AlibabaWdkMarketingVersionGenerateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 档期版本号参数信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SeasonVersionParam extends TaobaoObject {

	private static final long serialVersionUID = 3143575549192187283L;

	/**
		 * 商家档期号
		 */
		@ApiField("out_season_id")
		private String outSeasonId;
		/**
		 * 参与换挡的门店列表
		 */
		@ApiListField("shop_ids")
		@ApiField("string")
		private List<String> shopIds;
	

	public String getOutSeasonId() {
			return this.outSeasonId;
		}
		public void setOutSeasonId(String outSeasonId) {
			this.outSeasonId = outSeasonId;
		}
		public List<String> getShopIds() {
			return this.shopIds;
		}
		public void setShopIds(List<String> shopIds) {
			this.shopIds = shopIds;
		}

}


}